<?php // File: hr.php

require('hr_cn.inc');
require('hr_db.inc');
require('hr_ui.inc');

session_start();
if (!isset($_REQUEST['do']) && !ui_islogged_in()) {
    do_login();
}
else {
  $doreq = isset($_REQUEST['do']) ? $_REQUEST['do'] : "showdept";
  if ($doreq == "logout") {
    do_logout();
  }
  elseif ($doreq == "showemp") {
    construct_employees();
  }
  else {
    construct_departments();
  } 
}  

function do_login() {
  if (isset($_POST['username']) && isset($_POST['password'])) {
    $un = $_POST['username']; 
    $pw = $_POST['password']; 
	
	$conn = db_connect($un, $pw);
	if ($conn) {
      $_SESSION['UN'] = $un;
      $_SESSION['PW'] = $pw;
	  $_SESSION['loggedin'] = true;
	  header("Location: http://" . $_SERVER['HTTP_HOST'] . $_SERVER['SCRIPT_NAME']);
      exit;
	}
	else {
	  ui_print_error();
	}
  }
  else { 
    ui_print_header('Login');
    ui_print_login_form($_SERVER['SCRIPT_NAME']);
    ui_print_footer(date('Y-m-d H:i:s'));
  }
}

function do_logout() {
  unset($_SESSION['loggedin']);
    ui_print_header('Logout');
    echo "<p>You have logged out</p>";
	echo "<p><a href=".$_SERVER['SCRIPT_NAME'].">Login</a></p>";
    ui_print_footer(date('Y-m-d H:i:s'));
}

function construct_departments()
{
  $query =
    "SELECT d.department_id, d.department_name,
	     substr(e.first_name,1,1)||'. '|| e.last_name manager_name,
         c.country_name, count(e2.employee_id) number_of_employees
     FROM  departments d, employees e, locations l, 
	       countries c, employees e2
     WHERE d.manager_id = e.employee_id
     AND d.location_id = l.location_id
     AND d.department_id = e2.department_id
     AND l.country_id = c.country_id
     GROUP BY d.department_id, d.department_name, 
	          substr(e.first_name,1,1)||'. '||e.last_name,  
			  c.country_name
     ORDER BY d.department_id ASC";

  $un = $_SESSION['UN'];
  $pw = $_SESSION['PW'];
  $conn = db_connect($un, $pw);
  if (!$conn) {
    ui_print_error();
  }
  $dept = db_do_query($conn, $query);
  if ($dept) {
    ui_print_header('Departments');
    ui_print_department($dept);
    ui_print_footer(date('Y-m-d H:i:s'));
  }
  else {
    ui_print_error();
  }
}

function construct_employees()
{
  $query =
    "SELECT e.employee_id,
            substr(e.first_name,1,1) || '.  '|| e.last_name as employee_name,
            hire_date,
            to_char(e.salary, '9999G999D99') as salary,
            nvl(e.commission_pct,0) as commission_pct,
			d.department_name
     FROM   employees e, departments d
	 WHERE  e.department_id = d.department_id 
	 AND    d.department_id = to_number(nvl(to_char(:did), to_char(d.department_id)))
     ORDER BY e.employee_id ASC";

  $un = $_SESSION['UN'];
  $pw = $_SESSION['PW'];
  $conn = db_connect($un, $pw);
  if (!$conn) {
    ui_print_error();
  }
  
  $deptid = isset($_REQUEST['deptid']) ? $_REQUEST['deptid'] : null;
  $bindargs = array();
  array_push($bindargs, array('DID', $deptid, -1));
 
  $emp = db_do_query($conn, $query, OCI_FETCHSTATEMENT_BY_ROW, $bindargs);
  if ($emp) {
    if ($deptid == "NULL") {
      ui_print_header('Employees');
	}
	else {
	  ui_print_header('Employees: '.$emp[0]['DEPARTMENT_NAME']);
    }
	ui_print_employees($emp);
    ui_print_footer(date('Y-m-d H:i:s'));
  }
  else {
    ui_print_error();
  }
}

?>