<?php  // File: hr_db.inc

function db_connect($un = ORA_CON_UN, $pw = ORA_CON_PW)
{
  $conn = @oci_connect($un, $pw, ORA_CON_DB);
  if (!$conn) {
    db_error(null, __FILE__, __LINE__);
	return false;
  }
  return($conn);
}

function db_do_query($conn, $statement, $resulttype = OCI_FETCHSTATEMENT_BY_ROW, 
                     $bindvars = array())
{
  $stid = @oci_parse($conn, $statement);
  if (!$stid) {
    db_error($conn, __FILE__, __LINE__);
	return false;
  }
  
  // Bind the PHP values to query bind parameters
  foreach ($bindvars as $b) {
    // create local variable with caller specified bind value
    $$b[0] = $b[1];  
	// oci_bind_by_name(resource, bv_name, php_variable, length)
    $r = @oci_bind_by_name($stid, ":$b[0]", $$b[0], $b[2]); 
    if (!$r) {
      db_error($stid, __FILE__, __LINE__);
	  return false;
    }
  }

  $r = @oci_execute($stid, OCI_DEFAULT);
  if (!$r) {
    db_error($stid, __FILE__, __LINE__);
	return false;
  }
  $r = @oci_fetch_all($stid, $results, null, null, $resulttype);

  return($results);
}

// $r is the resource containing the error.
// Pass no argument or false for connection errors
function db_error($r = false, $file, $line)
{
  $err = $r ? @oci_error($r) : @oci_error();

  if (isset($err['message'])) {
    $m = htmlentities($err['message']);
    $c = $err['code'];
  }
  else {
    $m = 'Unknown DB error';
    $c = null;
  }

  $rc = array(
    'MESSAGE' => $m,
    'CODE' => $c,
    'FILE' => $file,
    'LINE' => $line);
  $_SESSION['err'] = $rc;
}

?>
