<?php // File: hr_ui.inc

function ui_islogged_in()
{
  return isset($_SESSION['loggedin']);
}

function ui_print_login_form($posturl)
{
  echo <<<END
   <form method="post" action="$posturl">
     <table>
       <tr>
	     <td>Username:</td><td><input name="username" type="text" size="20"></td>
	   </tr>
       <tr>
	     <td>Password:</td><td><input name="password" type="password" size="20"></td>
	   </tr>
	 </table>
	 <input type="submit" value="Login">&nbsp;<input type="reset" value="Clear">
   </form>
END;
}

function ui_print_header($title)
{
  $title = htmlentities($title);
  echo <<<END
  <!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01//EN"
     "http://www.w3.org/TR/html4/strict.dtd">
  <html>
  <head>
    <meta http-equiv="Content-Type"
          content="text/html; charset=ISO-8859-1">
    <link rel="stylesheet" type="text/css" href="style.css">
    <title>Sperling: $title</title>
  </head>
  <body>
  <h1>$title</h1>
END;
  if (ui_islogged_in()) {
    echo '<div class="logout">';
	echo "Logged in as <b><i>".$_SESSION['UN']."</i></b>&nbsp;";
    echo '<a href="'.$_SERVER['SCRIPT_NAME'].'?do=logout">Logout</a>';
    echo '</div>';
  }
}

function ui_print_footer($date)
{
  $date = htmlentities($date);
  echo <<<END
    <br>
	<div class="footer">
     <div class="date">$date</div>
     <div class="company">Sperling</div>
	</div>
  </body>
  </html>
END;
}

function ui_print_department($deptrecs)
{
  if (!$deptrecs) {
    echo '<p>No Department found</p>';
  }
  else {
    echo <<<END
    <table>
    <tr>
      <th>Id</th>
      <th>Name</th>
      <th>Number of<br>Employees</th>
      <th>Manager</th>
      <th>Location</th>
	  <!-- <th>List<br>Employees</th> -->
    </tr>
END;
    foreach ($deptrecs as $dept) {
      echo '<tr>';
      echo '<td>'.htmlentities($dept['DEPARTMENT_ID']).'</td>';
      echo '<td>'.htmlentities($dept['DEPARTMENT_NAME']).'</td>';
      echo '<td><a href='.$_SERVER['SCRIPT_NAME'].'?do=showemp&deptid='.
	       htmlentities($dept['DEPARTMENT_ID']).'>'.
	       htmlentities($dept['NUMBER_OF_EMPLOYEES']).'</a></td>';
      echo '<td>'.htmlentities($dept['MANAGER_NAME']).'</td>';
      echo '<td>'.htmlentities($dept['COUNTRY_NAME']).'</td>';
      echo '</tr>';
    }
    echo <<<END
    </table>
END;
  }
}

function ui_print_employees($employeerecords)
{
  if (!$employeerecords) {
    echo '<p>No Employee found</p>';
  }
  else {
    echo <<<END
  <table>
  <tr>
    <th>Employee<br>ID</th>
    <th>Employee<br>Name</th>
    <th>Hiredate</th>
    <th>Salary</th>
    <th>Commission<br>(%)</th>
  </tr>
END;
    // Write one row per employee
    foreach ($employeerecords as $emp) {
      echo '<tr>';
      echo '<td align="right">'.
	        htmlentities($emp['EMPLOYEE_ID']).'</td>';
      echo '<td>'.htmlentities($emp['EMPLOYEE_NAME']).'</td>';
      echo '<td>'.htmlentities($emp['HIRE_DATE']).'</td>';
      echo '<td align="right">'.
	        htmlentities($emp['SALARY']).'</td>';
      echo '<td align="right">'.
	        htmlentities($emp['COMMISSION_PCT']).'</td>';
      echo '</tr>';
    }	
    echo <<<END
  </table>
END;
  }
  if (isset($_REQUEST['deptid'])) {
    echo <<<END
    <form>
     <input type="button" value="Back" onClick="javascript:history.back();">
    </form>
END;
  }
}

function ui_print_error()
{
  ui_print_header('Error');
  if (!isset($_SESSION['err'])) {
    echo '<p>Unknown error</p>';
  }
  else {
    $message = $_SESSION['err'];
    echo "<p>Error at line {$message['LINE']} of ".
         "{$message['FILE']}</p>"; // Uncommented for debugging
    echo "<p>{$message['MESSAGE']}</p>";
	unset($_SESSION['err']);
  }
  echo <<<END
  <form>
  <input type="button" value="Back" onClick="javascript:history.back();">
  </form>
END;
  ui_print_footer(date('Y-m-d H:i:s'));
}

?>
