/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sanselan.formats.tiff.datareaders;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.apache.sanselan.ImageReadException;
import org.apache.sanselan.common.BitInputStream;
import org.apache.sanselan.common.byteSources.ByteSource;
import org.apache.sanselan.formats.tiff.datareaders.DataReader;
import org.apache.sanselan.formats.tiff.photometricinterpreters.PhotometricInterpreter;

public class DataReaderStrips
extends DataReader {
    private final int bitsPerPixel;
    private final int width;
    private final int height;
    private final int[] stripOffsets;
    private final int[] stripByteCounts;
    private final int compression;
    private final int rowsPerStrip;
    int x = 0;
    int y = 0;

    public DataReaderStrips(PhotometricInterpreter fPhotometricInterpreter, int fBitsPerPixel, int[] fBitsPerSample, int Predictor, int fSamplesPerPixel, int width, int height, int[] fStripOffsets, int[] fStripByteCounts, int fCompression, int fRowsPerStrip, int byteOrder) {
        super(fPhotometricInterpreter, fBitsPerSample, Predictor, fSamplesPerPixel, byteOrder);
        this.bitsPerPixel = fBitsPerPixel;
        this.width = width;
        this.height = height;
        this.stripOffsets = fStripOffsets;
        this.stripByteCounts = fStripByteCounts;
        this.compression = fCompression;
        this.rowsPerStrip = fRowsPerStrip;
    }

    public void interpretStrip(BufferedImage bi, byte[] bytes, int pixels_per_strip) throws ImageReadException, IOException {
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        BitInputStream bis = new BitInputStream(bais);
        for (int i = 0; i < pixels_per_strip; ++i) {
            int[] samples = this.getSamplesAsBytes(bis);
            if (this.x < this.width && this.y < this.height) {
                samples = this.applyPredictor(samples, this.x);
                this.photometricInterpreter.interpretPixel(bi, samples, this.x, this.y);
            }
            ++this.x;
            if (this.x < this.width) continue;
            this.x = 0;
            ++this.y;
            bis.flushCache();
            if (this.y >= this.height) break;
        }
    }

    public void readImageData(BufferedImage bi, ByteSource byteSource) throws ImageReadException, IOException {
        for (int strip = 0; strip < this.stripOffsets.length; ++strip) {
            int rows_remaining = this.height - strip * this.rowsPerStrip;
            int rows_in_this_strip = Math.min(rows_remaining, this.rowsPerStrip);
            int pixels_per_strip = rows_in_this_strip * this.width;
            int bytes_per_strip = (pixels_per_strip * this.bitsPerPixel + 7) / 8;
            int fStripOffset = this.stripOffsets[strip];
            int fStripByteCount = this.stripByteCounts[strip];
            byte[] compressed = byteSource.getBlock(fStripOffset, fStripByteCount);
            byte[] decompressed = this.decompress(compressed, this.compression, bytes_per_strip);
            this.interpretStrip(bi, decompressed, pixels_per_strip);
        }
    }
}

