/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sanselan.formats.pnm;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import org.apache.sanselan.ImageWriteException;
import org.apache.sanselan.formats.pnm.PNMWriter;

public class PBMWriter
extends PNMWriter {
    public PBMWriter(boolean RAWBITS) {
        super(RAWBITS);
    }

    public void writeImage(BufferedImage src, OutputStream os, Map params) throws ImageWriteException, IOException {
        os.write(80);
        os.write(this.RAWBITS ? 52 : 49);
        os.write(32);
        int width = src.getWidth();
        int height = src.getHeight();
        os.write(("" + width).getBytes());
        os.write(32);
        os.write(("" + height).getBytes());
        os.write(32);
        int bitcache = 0;
        int bits_in_cache = 0;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int blue;
                int green;
                int argb = src.getRGB(x, y);
                int red = 0xFF & argb >> 16;
                int sample = (red + (green = 0xFF & argb >> 8) + (blue = 0xFF & argb >> 0)) / 3;
                sample = sample > 127 ? 0 : 1;
                if (this.RAWBITS) {
                    bitcache = bitcache << 1 | 1 & sample;
                    if (++bits_in_cache < 8) continue;
                    os.write((byte)bitcache);
                    bitcache = 0;
                    bits_in_cache = 0;
                    continue;
                }
                os.write(("" + sample).getBytes());
                os.write(32);
            }
            if (!this.RAWBITS || bits_in_cache <= 0) continue;
            os.write((byte)bitcache);
            bitcache = 0;
            bits_in_cache = 0;
        }
    }
}

