package com.perpixelperfectcollision;

import org.anddev.andengine.opengl.texture.Texture;
import org.anddev.andengine.opengl.texture.atlas.bitmap.source.IBitmapTextureAtlasSource;
import org.anddev.andengine.opengl.texture.region.TiledTextureRegion;

import android.graphics.Bitmap;

public class PixelPerfectTiledTextureRegion extends TiledTextureRegion{
	
	protected IBitmapTextureAtlasSource ctextureSource;
	protected Texture ctexture;
    protected int cTexturePositionX;
    protected int cTexturePositionY;
    protected int cWidth;
    protected int cHeight;
    protected int ctileCols;
    protected int ctileRows;
	
	
    protected PixelPerfectBitMask[] bitMasks;
    protected int tileCols;
    protected int tileRows;
    
    public PixelPerfectBitMask getMask(int idx){
        return bitMasks[idx];
    }
    
    public PixelPerfectTiledTextureRegion(Texture pTexture, IBitmapTextureAtlasSource textureSource,
                                     int pTexturePositionX, int pTexturePositionY, 
                                     int pWidth, int pHeight,
                                     int tileCols, int tileRows
                                     ) {
        super(pTexture, pTexturePositionX, pTexturePositionY, pWidth, pHeight, tileCols, tileRows);
        Bitmap bmp = textureSource.onLoadBitmap(Bitmap.Config.ARGB_4444);
        
        int tileWidth = pWidth / tileCols;
        int tileHeight = pHeight / tileRows;
        bitMasks = new PixelPerfectBitMask[tileRows * tileCols];
        
        this.ctexture=pTexture;
        this.ctextureSource=textureSource;
        this.cTexturePositionX=pTexturePositionX;
        this.cTexturePositionY=pTexturePositionY;
        this.cWidth=pWidth;
        this.cHeight=pHeight;
        this.ctileCols=tileCols;
        this.ctileRows=tileRows;      
        
        for(int row=0; row<tileRows; row++){
            for(int col=0; col<tileCols; col++){
                bitMasks[row * tileCols + col] = new PixelPerfectBitMask(bmp, col * tileWidth, row * tileHeight, tileWidth, tileHeight);
            }
        }
    }
    
	public PixelPerfectTiledTextureRegion clone() {
		PixelPerfectTiledTextureRegion cloned= new PixelPerfectTiledTextureRegion(this.ctexture,this.ctextureSource,this.cTexturePositionX,this.cTexturePositionY,this.cWidth,this.cHeight,this.ctileCols,this.ctileRows);
		return cloned;
	}
    
}
