/*
 * Decompiled with CFR 0.152.
 */
package com.google.analytics.tracking.android;

import android.text.TextUtils;
import com.google.analytics.tracking.android.Dispatcher;
import com.google.analytics.tracking.android.Hit;
import com.google.analytics.tracking.android.HitBuilder;
import com.google.analytics.tracking.android.Log;
import java.util.List;

class NoopDispatcher
implements Dispatcher {
    NoopDispatcher() {
    }

    @Override
    public boolean okToDispatch() {
        return true;
    }

    @Override
    public int dispatchHits(List<Hit> hits) {
        if (hits == null) {
            return 0;
        }
        Log.iDebug("Hits not actually being sent as dispatch is false...");
        int maxHits = Math.min(hits.size(), 40);
        for (int i = 0; i < maxHits; ++i) {
            String modifiedHit;
            if (!Log.debugEnabled()) continue;
            String logMessage = null;
            String hitString = hits.get(i).getHitParams();
            String string = modifiedHit = TextUtils.isEmpty((CharSequence)hitString) ? "" : HitBuilder.postProcessHit(hits.get(i), System.currentTimeMillis());
            logMessage = TextUtils.isEmpty((CharSequence)modifiedHit) ? "Hit couldn't be read, wouldn't be sent:" : (modifiedHit.length() <= 2036 ? "GET would be sent:" : (modifiedHit.length() > 8192 ? "Would be too big:" : "POST would be sent:"));
            Log.iDebug(logMessage + modifiedHit);
        }
        return maxHits;
    }
}

