/*
 * Decompiled with CFR 0.152.
 */
package stx_customoverlay;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Point;
import android.location.Location;
import com.google.android.maps.GeoPoint;
import com.google.android.maps.MapView;
import com.google.android.maps.MyLocationOverlay;
import com.google.android.maps.Projection;
import com.stx_downhill_tracker.R;

public class CustomMyLocationOverlay
extends MyLocationOverlay {
    private Context mContext;
    private float mOrientation;
    private float accuracy = 10.0f;

    public CustomMyLocationOverlay(Context context, MapView mapView) {
        super(context, mapView);
        this.mContext = context;
    }

    protected void drawMyLocation(Canvas canvas, MapView mapView, Location lastFix, GeoPoint myLocation, long when) {
        Point screenPts = mapView.getProjection().toPixels(myLocation, null);
        Bitmap arrowBitmap = BitmapFactory.decodeResource((Resources)this.mContext.getResources(), (int)R.drawable.mycurrentlocation_icon);
        Matrix matrix = new Matrix();
        matrix.postRotate(this.mOrientation);
        Bitmap rotatedBmp = Bitmap.createBitmap((Bitmap)arrowBitmap, (int)0, (int)0, (int)arrowBitmap.getWidth(), (int)arrowBitmap.getHeight(), (Matrix)matrix, (boolean)true);
        canvas.drawBitmap(rotatedBmp, (float)(screenPts.x - rotatedBmp.getWidth() / 2), (float)(screenPts.y - (rotatedBmp.getHeight() / 2 + 14)), null);
        Projection projection = mapView.getProjection();
        Point center = new Point();
        int radius = (int)projection.metersToEquatorPixels(this.accuracy);
        projection.toPixels(myLocation, center);
        Paint accuracyPaint = new Paint();
        accuracyPaint.setAntiAlias(true);
        accuracyPaint.setStrokeWidth(2.0f);
        accuracyPaint.setColor(-5963776);
        accuracyPaint.setStyle(Paint.Style.STROKE);
        canvas.drawCircle((float)center.x, (float)center.y, (float)radius, accuracyPaint);
        accuracyPaint.setColor(417762304);
        accuracyPaint.setStyle(Paint.Style.FILL);
        canvas.drawCircle((float)center.x, (float)center.y, (float)radius, accuracyPaint);
    }

    public void setAccuracy(float tacc) {
        this.accuracy = tacc;
    }

    public void setOrientation(float newOrientation) {
        this.mOrientation = newOrientation;
    }
}

