/*
 * Decompiled with CFR 0.152.
 */
package stx_customoverlay;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Point;
import com.google.android.maps.GeoPoint;
import com.google.android.maps.MapActivity;
import com.google.android.maps.MapView;
import com.google.android.maps.Overlay;

public class MarkerOnTrackOverlay
extends Overlay {
    private GeoPoint location = null;
    private MapActivity mapActivity;
    private int type_of_mark;
    private int offset = 0;
    private float mOrientation;

    public MarkerOnTrackOverlay(GeoPoint location, MapActivity tmapActivity, int ttype_of_mark, int toffset) {
        this.location = location;
        this.mapActivity = tmapActivity;
        this.type_of_mark = ttype_of_mark;
        this.offset = toffset;
    }

    public void draw(Canvas canvas, MapView mapView, boolean shadow) {
        super.draw(canvas, mapView, shadow);
        Point screenPoint = new Point();
        Point screenPts = mapView.getProjection().toPixels(this.location, screenPoint);
        Bitmap arrowBitmap = BitmapFactory.decodeResource((Resources)this.mapActivity.getResources(), (int)this.type_of_mark);
        Matrix matrix = new Matrix();
        matrix.postRotate(this.mOrientation);
        Bitmap rotatedBmp = Bitmap.createBitmap((Bitmap)arrowBitmap, (int)0, (int)0, (int)arrowBitmap.getWidth(), (int)arrowBitmap.getHeight(), (Matrix)matrix, (boolean)true);
        canvas.drawBitmap(rotatedBmp, (float)(screenPts.x - rotatedBmp.getWidth() / 2), (float)(screenPts.y - (rotatedBmp.getHeight() / 2 + this.offset)), null);
    }
}

