/*
 * Decompiled with CFR 0.152.
 */
package stx_main;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.os.Bundle;
import android.os.Handler;
import android.view.View;
import android.widget.ImageButton;
import android.widget.TextView;
import com.google.android.maps.GeoPoint;
import com.google.android.maps.MapActivity;
import com.google.android.maps.MapController;
import com.google.android.maps.MapView;
import com.google.android.maps.OverlayItem;
import com.stx_downhill_tracker.R;
import stx_commons.stx_GPS;
import stx_commons.stx_calculations;
import stx_commons.stx_commons;
import stx_customoverlay.CustomMyLocationOverlay;
import stx_customoverlay.MarkerOnTrackItemizedOverlay;
import stx_customoverlay.MarkerOnTrackOverlay;
import stx_customoverlay.PathOverlay;
import stx_customoverlay.ShapeOnTrackOverlay;

public class progressbar_maps_Activity
extends MapActivity {
    private MapView mapView;
    private MapController mapController;
    private ImageButton button_start_tracking;
    private TextView text_total_distance;
    CustomMyLocationOverlay currentLocationOverlay;
    public GeoPoint last_Geopoint = null;
    public GeoPoint new_Geopoint = null;
    public MarkerOnTrackItemizedOverlay itemizedOverlay;
    public int current_distance_beetween_check_points;
    private Drawable icon_new_geopoint;
    private Drawable icon_new_checkpoint;
    private Handler handler = new Handler();
    private Runnable refreshTask = new Runnable(){

        public void run() {
            progressbar_maps_Activity.this.handler.removeCallbacks((Runnable)this);
            if (progressbar_maps_Activity.this.currentLocationOverlay.getMyLocation() != null) {
                progressbar_maps_Activity.this.mapController.animateTo(progressbar_maps_Activity.this.currentLocationOverlay.getMyLocation());
            }
            progressbar_maps_Activity.this.mapView.postInvalidate();
            progressbar_maps_Activity.this.handler.postDelayed((Runnable)this, stx_commons.myCurrent_position_time_refresh);
        }
    };

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.google_maps);
        this.button_start_tracking = (ImageButton)this.findViewById(R.id.button_start_tracking);
        this.text_total_distance = (TextView)this.findViewById(R.id.tracking_distance);
        this.icon_new_geopoint = this.getResources().getDrawable(R.drawable.pin_point);
        this.icon_new_checkpoint = this.getResources().getDrawable(R.drawable.pin_check);
        this.icon_new_geopoint.setBounds(0, 0, this.icon_new_geopoint.getIntrinsicWidth(), this.icon_new_geopoint.getIntrinsicHeight());
        this.icon_new_checkpoint.setBounds(0, 0, this.icon_new_checkpoint.getIntrinsicWidth(), this.icon_new_checkpoint.getIntrinsicHeight());
        this.itemizedOverlay = new MarkerOnTrackItemizedOverlay(this.icon_new_geopoint);
        stx_GPS.locationManager = (LocationManager)this.getSystemService("location");
        stx_GPS.locationManager.addGpsStatusListener(stx_GPS.onGpsStatusChange);
        stx_GPS.onGpsStatusChange.onGpsStatusChanged(4);
        this.initMapView();
        this.initMyLocation();
        this.initMyLocationTracker();
        this.button_start_tracking.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (stx_commons.is_start_tracking) {
                    if (progressbar_maps_Activity.this.last_Geopoint != null) {
                        progressbar_maps_Activity.this.button_start_tracking.setImageResource(R.drawable.tracking_record_0);
                        stx_commons.is_start_tracking = false;
                        stx_commons.showToast(progressbar_maps_Activity.this.getApplicationContext(), "Track recording is stopped.");
                        PathOverlay pathOverlay = new PathOverlay(progressbar_maps_Activity.this.last_Geopoint, progressbar_maps_Activity.this.new_Geopoint);
                        progressbar_maps_Activity.this.mapView.getOverlays().add(pathOverlay);
                        MarkerOnTrackOverlay marker = new MarkerOnTrackOverlay(progressbar_maps_Activity.this.new_Geopoint, progressbar_maps_Activity.this, R.drawable.pin_finish, 14);
                        progressbar_maps_Activity.this.mapView.getOverlays().add(marker);
                        progressbar_maps_Activity.this.mapView.invalidate();
                    }
                } else {
                    progressbar_maps_Activity.this.button_start_tracking.setImageResource(R.drawable.tracking_record_1);
                    stx_commons.is_start_tracking = true;
                    stx_commons.showToast(progressbar_maps_Activity.this.getApplicationContext(), "Track recording is started.");
                }
            }
        });
        this.button_start_tracking.setImageResource(R.drawable.tracking_record_0_dis);
        this.button_start_tracking.setClickable(false);
    }

    private void initMapView() {
        this.mapView = (MapView)this.findViewById(R.id.mapview);
        this.mapController = this.mapView.getController();
        this.mapView.setSatellite(false);
        this.mapView.setBuiltInZoomControls(true);
    }

    private void initMyLocation() {
        stx_GPS.locationManager = (LocationManager)this.getSystemService("location");
        this.currentLocationOverlay = new CustomMyLocationOverlay((Context)this, this.mapView);
        this.currentLocationOverlay.enableMyLocation();
        this.currentLocationOverlay.runOnFirstFix(new Runnable(){

            public void run() {
                progressbar_maps_Activity.this.mapController.setZoom(24);
                progressbar_maps_Activity.this.mapController.animateTo(progressbar_maps_Activity.this.currentLocationOverlay.getMyLocation());
            }
        });
        stx_commons.projection = this.mapView.getProjection();
        this.mapView.getOverlays().add(this.currentLocationOverlay);
        Thread t = new Thread(this.refreshTask);
        t.start();
    }

    private void initMyLocationTracker() {
        LocationListener locationListener = new LocationListener(){

            public void onLocationChanged(Location location) {
                if (location.hasAccuracy()) {
                    progressbar_maps_Activity.this.currentLocationOverlay.setAccuracy(location.getAccuracy());
                    if ((int)location.getAccuracy() < stx_commons.minium_GPS_accuracy) {
                        if (!progressbar_maps_Activity.this.button_start_tracking.isClickable() && !stx_commons.is_start_tracking) {
                            progressbar_maps_Activity.this.button_start_tracking.setImageResource(R.drawable.tracking_record_0);
                            progressbar_maps_Activity.this.button_start_tracking.setClickable(true);
                        }
                        if (stx_commons.is_start_tracking) {
                            progressbar_maps_Activity.this.new_Geopoint = new GeoPoint((int)(location.getLatitude() * 1000000.0), (int)(location.getLongitude() * 1000000.0));
                            if (progressbar_maps_Activity.this.last_Geopoint != null) {
                                float distance_beetween_two_points = stx_calculations.getDistanceInMeters(progressbar_maps_Activity.this.new_Geopoint, progressbar_maps_Activity.this.last_Geopoint);
                                if (distance_beetween_two_points >= stx_commons.distance_beetween_track_points) {
                                    stx_commons.geoPointsArray.add(progressbar_maps_Activity.this.new_Geopoint);
                                    PathOverlay pathOverlay = new PathOverlay(progressbar_maps_Activity.this.last_Geopoint, progressbar_maps_Activity.this.new_Geopoint);
                                    progressbar_maps_Activity.this.mapView.getOverlays().add(pathOverlay);
                                    progressbar_maps_Activity.this.text_total_distance.setText((CharSequence)(String.valueOf(Integer.toString((int)Math.floor(stx_calculations.ct_total_distance += stx_calculations.getDistanceInMeters(progressbar_maps_Activity.this.new_Geopoint, progressbar_maps_Activity.this.last_Geopoint)))) + " m"));
                                    OverlayItem overlayItem = new OverlayItem(progressbar_maps_Activity.this.new_Geopoint, "Point", null);
                                    overlayItem.setMarker(progressbar_maps_Activity.this.icon_new_geopoint);
                                    progressbar_maps_Activity.this.itemizedOverlay.addOverlayItem(overlayItem);
                                    progressbar_maps_Activity.this.itemizedOverlay.getFocus();
                                    progressbar_maps_Activity.this.mapView.getOverlays().add(progressbar_maps_Activity.this.itemizedOverlay);
                                    if (stx_calculations.ct_total_distance - (float)progressbar_maps_Activity.this.current_distance_beetween_check_points > (float)stx_commons.distance_beetween_check_points) {
                                        progressbar_maps_Activity.this.current_distance_beetween_check_points = (int)Math.floor(stx_calculations.ct_total_distance);
                                        stx_commons.checkPointsArray.add(progressbar_maps_Activity.this.new_Geopoint);
                                        ShapeOnTrackOverlay checkpointArea = new ShapeOnTrackOverlay((Context)progressbar_maps_Activity.this, progressbar_maps_Activity.this.new_Geopoint, location.getAccuracy());
                                        progressbar_maps_Activity.this.mapView.getOverlays().add(checkpointArea);
                                        progressbar_maps_Activity.this.mapView.invalidate();
                                    }
                                    progressbar_maps_Activity.this.last_Geopoint = progressbar_maps_Activity.this.new_Geopoint;
                                }
                            } else {
                                stx_commons.geoPointsArray.add(progressbar_maps_Activity.this.new_Geopoint);
                                MarkerOnTrackOverlay marker = new MarkerOnTrackOverlay(progressbar_maps_Activity.this.new_Geopoint, progressbar_maps_Activity.this, R.drawable.pin_start, 14);
                                progressbar_maps_Activity.this.mapView.getOverlays().add(marker);
                                progressbar_maps_Activity.this.mapView.invalidate();
                                progressbar_maps_Activity.this.last_Geopoint = progressbar_maps_Activity.this.new_Geopoint;
                            }
                        }
                    } else if (!stx_commons.is_start_tracking) {
                        progressbar_maps_Activity.this.button_start_tracking.setImageResource(R.drawable.tracking_record_0_dis);
                        progressbar_maps_Activity.this.button_start_tracking.setClickable(false);
                    }
                }
            }

            public void onStatusChanged(String provider, int status, Bundle extras) {
            }

            public void onProviderEnabled(String provider) {
            }

            public void onProviderDisabled(String provider) {
            }
        };
        stx_GPS.locationManager.requestLocationUpdates("gps", 0L, 0.0f, locationListener);
        stx_GPS.locationManager.requestLocationUpdates("network", 0L, 0.0f, locationListener);
    }

    protected boolean isRouteDisplayed() {
        return false;
    }
}

