package com.mkyong.android;

import android.app.Activity;
import android.os.Bundle;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.ArrayAdapter;
import android.widget.AutoCompleteTextView;
import android.widget.ImageButton;
import android.widget.Toast;

public class MyAndroidAppActivity extends Activity {

	ImageButton imageButton1;
	ImageButton imageButton2;
	ImageButton imageButton3;

	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.main);

		addListenerOnButton();

	}

	public void addListenerOnButton() {

		imageButton1 = (ImageButton) findViewById(R.id.imageButton1);
		imageButton2 = (ImageButton) findViewById(R.id.imageButton2);
		imageButton3 = (ImageButton) findViewById(R.id.imageButton3);
		
		imageButton1.setOnClickListener(new OnClickListener() {

			@Override
			public void onClick(View arg0) {

				Toast.makeText(MyAndroidAppActivity.this,
						"ImageButton is clicked!", Toast.LENGTH_SHORT).show();

			}


		});

		imageButton2.setOnClickListener(new OnClickListener() {

			@Override
			public void onClick(View arg0) {

				Toast.makeText(MyAndroidAppActivity.this,
						"Viva", Toast.LENGTH_SHORT).show();

			}


		});
		
		imageButton3.setOnClickListener(new OnClickListener() {

			@Override
			public void onClick(View arg0) {

				Toast.makeText(MyAndroidAppActivity.this,
						"Muera", Toast.LENGTH_SHORT).show();

			}


		});
		// Get a reference to the AutoCompleteTextView in the layout
		AutoCompleteTextView textView = (AutoCompleteTextView) findViewById(R.id.autocomplete_country);
		// Get the string array
		String[] countries = getResources().getStringArray(R.array.countries_array);
		// Create the adapter and set it to the AutoCompleteTextView 
		ArrayAdapter<String> autoadapter=new ArrayAdapter<String>(this,android.R.layout.simple_list_item_1,countries);
		textView.setAdapter(autoadapter);
	}

}