package stx_main;

import java.util.ArrayList;
import java.util.List;

import android.content.Context;
import android.content.Intent;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.location.GpsStatus;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.os.Bundle;
import android.os.Handler;
import android.util.Log;
import android.view.Gravity;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.RotateAnimation;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.TextView;
import android.widget.Toast;

import com.google.android.maps.GeoPoint;
import com.google.android.maps.MapActivity;
import com.google.android.maps.MapController;
import com.google.android.maps.MapView;
import com.google.android.maps.MyLocationOverlay;
import com.google.android.maps.Overlay;
import com.google.android.maps.OverlayItem;
import com.stx_downhill_tracker.R;

import stx_commons.stx_GPS;
import stx_commons.stx_calculations;
import stx_commons.stx_commons;
import stx_customoverlay.CustomMyLocationOverlay;
import stx_customoverlay.MarkerOnTrackItemizedOverlay;
import stx_customoverlay.MarkerOnTrackOverlay;
import stx_customoverlay.PathOverlay;
import stx_customoverlay.ShapeOnTrackOverlay;

public class progressbar_maps_Activity extends MapActivity implements
		SensorEventListener {

	private MapView mapView; // Activity que extend de MapActivity (es la vista
								// per defecte del Google Maps)
	private MapController mapController; // Inicialitzacio del controlador

	private ImageButton button_start_tracking; // Textura amb propietats de botó
	private TextView text_total_distance; // Text que mostrarà el càlcul total
											// de distància recorreguda.

	CustomMyLocationOverlay currentLocationOverlay; // Capa associada per
													// defecte a la vista del
													// googleMaps (mostra el
													// punt actual)

	// Check FastCalculations
	public GeoPoint last_Geopoint = null; // Punts que guarden coordenades de
											// geocalització. S'utilitzen dos
											// per a poder traçar línies d'un
											// punt a un d'anterior.
	public GeoPoint new_Geopoint = null;

	public MarkerOnTrackItemizedOverlay itemizedOverlay; //

	public int current_distance_beetween_check_points;

	/* ********************************
	 * Procès de d'inicialització de la bruixola. Implements:
	 * SensorEventListener. Classes implementades:
	 * 
	 * public void onSensorChanged(SensorEvent event) public void
	 * onAccuracyChanged(Sensor sensor, int accuracy)
	 * 
	 * **********************************
	 */

	geopoint_info gp = new geopoint_info();

	private float grausActuals = 0f;
	double x, y, z; // Coordenades dels geopoints de salt.

	// GENERAR EL IMAGEVIEW DES DEL DRAWABLE.

	TextView mostraGraus;
	private ImageView arrow;

	// Sensor Manager

	private SensorManager mSensorManager; // SENSOR BRUJULA
	private SensorManager mSensorAccel; // SENSOR ACELEROMETRE

	// ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
	// Processo de refresco del posicionamiento actual de la marca de donde
	// estoy
	// ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

	// Lista de puntos a a�adir por cada segmento

	// Icono de inicio de recorrido
	private Drawable icon_new_geopoint;
	private Drawable icon_new_checkpoint;

	private Handler handler = new Handler();
	private Runnable refreshTask = new Runnable() {
		public void run() {
			handler.removeCallbacks(this);
			// Posiciona el mapa
			if (currentLocationOverlay.getMyLocation() != null) {
				mapController.animateTo(currentLocationOverlay.getMyLocation());
			}
			// Force redraw
			mapView.postInvalidate();
			// Delay 2 seconds
			handler.postDelayed(this,
					stx_commons.myCurrent_position_time_refresh);

		}
	};

	@SuppressWarnings("deprecation")
	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.google_maps);

		/****
		 * 
		 * 
		 * BRUIXOLA
		 * 
		 */

		// initialize your android device sensor capabilities

		mSensorManager = (SensorManager) getSystemService(SENSOR_SERVICE);

		mSensorManager.registerListener(this,
				mSensorManager.getDefaultSensor(Sensor.TYPE_ORIENTATION),
				SensorManager.SENSOR_DELAY_GAME);

		/***********************************************************
		 *********************************************************** 
		 //******************SENSOR ACCELEROMETRE********************
		 *********************************************************** 
		 **********************************************************/

		mSensorAccel = (SensorManager) getSystemService(SENSOR_SERVICE);
		mSensorAccel.registerListener(this,
				mSensorAccel.getDefaultSensor(Sensor.TYPE_ACCELEROMETER),
				SensorManager.SENSOR_DELAY_GAME);

		/*****************************************
      * ***************************************/

		// Creació del imageview de la fletxa (bruixola)

		arrow = (ImageView) findViewById(R.id.arrow);

		// stx_commons.appStatus = (TextView)findViewById(R.id.textViewMap);

		// Images init
		button_start_tracking = (ImageButton) findViewById(R.id.button_start_tracking);
		// Texto de distancia total
		text_total_distance = (TextView) findViewById(R.id.tracking_distance);

		// Icono GEO i CHECK
		icon_new_geopoint = getResources().getDrawable(R.drawable.pin_point);
		icon_new_checkpoint = getResources().getDrawable(R.drawable.pin_check);

		icon_new_geopoint.setBounds(0, 0,
				icon_new_geopoint.getIntrinsicWidth(),
				icon_new_geopoint.getIntrinsicHeight());
		icon_new_checkpoint.setBounds(0, 0,
				icon_new_checkpoint.getIntrinsicWidth(),
				icon_new_checkpoint.getIntrinsicHeight());

		// Puntos entre linias tipo itemized sin shadow
		itemizedOverlay = new MarkerOnTrackItemizedOverlay(icon_new_geopoint);

		// Check GPS Signal
		stx_GPS.locationManager = (LocationManager) getSystemService(Context.LOCATION_SERVICE);
		stx_GPS.locationManager.addGpsStatusListener(stx_GPS.onGpsStatusChange);
		stx_GPS.onGpsStatusChange
				.onGpsStatusChanged(GpsStatus.GPS_EVENT_SATELLITE_STATUS);

		initMapView();
		initMyLocation();
		initMyLocationTracker();

		// Listener del botton de inicio de tracking
		button_start_tracking.setOnClickListener(new View.OnClickListener() {
			public void onClick(View v) {
				if (stx_commons.is_start_tracking) {
					// Fins que no tinguem com a minim dos punts valids no le
					// permitas al usuario parar el tracking
					if (last_Geopoint != null) {
						button_start_tracking
								.setImageResource(R.drawable.tracking_record_0);
						stx_commons.is_start_tracking = false;
						stx_commons.showToast(getApplicationContext(),
								"Track recording is stopped.");

						// LAST LINE
						PathOverlay pathOverlay = new PathOverlay(
								last_Geopoint, new_Geopoint);
						// A�ade otra layer que tiene una linia entre dos
						// puntos.
						mapView.getOverlays().add(pathOverlay);

						// FINISH
						MarkerOnTrackOverlay marker = new MarkerOnTrackOverlay(
								new_Geopoint, progressbar_maps_Activity.this,
								R.drawable.pin_finish, 14);
						mapView.getOverlays().add(marker);
						mapView.invalidate();
					}

				} else {
					button_start_tracking
							.setImageResource(R.drawable.tracking_record_1);
					stx_commons.is_start_tracking = true;
					stx_commons.showToast(getApplicationContext(),
							"Track recording is started.");
				}

			}
		});

		// Por defecto esta disabled por que el listener lo activa con un buen
		// GPS accuracy
		button_start_tracking
				.setImageResource(R.drawable.tracking_record_0_dis);
		button_start_tracking.setClickable(false);

	}

	// ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
	// Inicializa el Mapa
	// ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
	private void initMapView() {
		mapView = (MapView) findViewById(R.id.mapview); // Carrega el xml de
														// Google Maps al
														// mapView
		mapController = mapView.getController(); // Indica quin es el
													// controlador del mapa
		mapView.setSatellite(false); // No tria cap satellite específic
		mapView.setBuiltInZoomControls(true); // Permet els controls de zoom
												// mitjançant botons.
	}

	// ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
	// Posicioname en mi mapa
	// ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
	private void initMyLocation() {

		stx_GPS.locationManager = (LocationManager) getSystemService(Context.LOCATION_SERVICE); // Demanem
																								// localització

		currentLocationOverlay = new CustomMyLocationOverlay(this, mapView); // Introduim
																				// al
																				// mapa
																				// la
																				// nostra
																				// localització
																				// actual
																				// amb
																				// l'icona
																				// corresponent.
		currentLocationOverlay.enableMyLocation(); // Engega el procès de
													// localització.

		// overlay.enableCompass(); // does not work in emulator

		currentLocationOverlay.runOnFirstFix(new Runnable() { // Executem un
																// petit thread
																// que posa el
																// zoom a 24 i
																// anima el mapa
																// per a moure'l
																// fins al punt
																// on ens
																// trobem.
					public void run() {
						// Zoom in to current location
						mapController.setZoom(24);
						mapController.animateTo(currentLocationOverlay
								.getMyLocation());
					}
				});

		stx_commons.projection = mapView.getProjection();

		// A�ade la layer pricipal de mi posicion actual
		mapView.getOverlays().add(currentLocationOverlay);

		// Activa la tarea de actualizacion de mi posicion cada X tiempo
		Thread t = new Thread(refreshTask);
		t.start();
	}

	// ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
	// Inicializa el listener que pinta la linias entre dos puntos detectados
	// solo cuando:
	// - La localizacion ha cambiado
	// - La senyal GPs es buena
	// -
	// ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
	private void initMyLocationTracker() {
		// LocationManager locationManager =
		// (LocationManager)getSystemService(LOCATION_SERVICE);
		// button_start_tracking=(ImageButton)findViewById(R.id.button_start_tracking);

		LocationListener locationListener = new LocationListener() {
			public void onLocationChanged(Location location) // Aquesta funció
																// es llença
																// cada cop que
																// la posició
																// GPS varia.
			{
				// Only try if thre's Accuracy
				if (location.hasAccuracy()) {

					// Change radius on accuracy
					currentLocationOverlay.setAccuracy(location.getAccuracy());

					// Check the accuracy if not discard location
					if ((int) location.getAccuracy() < stx_commons.minium_GPS_accuracy) {

						if (!button_start_tracking.isClickable()
								&& !stx_commons.is_start_tracking) {
							button_start_tracking
									.setImageResource(R.drawable.tracking_record_0);
							button_start_tracking.setClickable(true);
						}

						if (stx_commons.is_start_tracking) {
							// Es igual no que tingui o no bona accuracy (si la
							// te guardem si no res)
							new_Geopoint = new GeoPoint(
									(int) (location.getLatitude() * 1E6),
									(int) (location.getLongitude() * 1E6));

							// Como minimo hay dos puntos para una linia
							// if(stx_commons.geoPointsArray.size()>=1)
							if (last_Geopoint != null) {
								// Si hay mas de dos puntos proponemos este para
								// a�adir a la lista de puntos pero
								// lo haremos solo si hay una distancia minima
								// de X metros

								// Ahora que tenemos los dos geopoints calcula
								// la distacia entre ellos en metros
								float distance_beetween_two_points = stx_calculations
										.getDistanceInMeters(new_Geopoint,
												last_Geopoint);

								// Si hay mas de X metros entre los puntos
								// accion si no descartamos
								if (distance_beetween_two_points >= stx_commons.distance_beetween_track_points) {

									// +++ A�ade a la lista de puntos en
									// tracking visible

									stx_commons.geoPointsArray
											.add(new geopoint_info(x, y, z,
													new_Geopoint, grausActuals));

									// ***********
									// LINEAS
									// ***********

									PathOverlay pathOverlay = new PathOverlay(
											last_Geopoint, new_Geopoint);
									// A�ade otra layer que tiene una linia
									// entre dos puntos.
									mapView.getOverlays().add(pathOverlay);

									// ***********
									// P U N T O S O C H E C K P O I N T S
									// ***********

									// Ahora que tenemos los dos geopoints
									// calcula la distacia entre ellos en metros
									stx_calculations.ct_total_distance += stx_calculations
											.getDistanceInMeters(new_Geopoint,
													last_Geopoint);
									text_total_distance
											.setText(Integer.toString((int) Math
													.floor(stx_calculations.ct_total_distance))
													+ " m");

									// OVERLAY
									OverlayItem overlayItem = new OverlayItem(
											new_Geopoint, "Point", null);
									overlayItem.setMarker(icon_new_geopoint);
									itemizedOverlay.addOverlayItem(overlayItem);
									itemizedOverlay.getFocus();
									mapView.getOverlays().add(itemizedOverlay);

									// DETERMINA si es CHECKPOINT
									if ((stx_calculations.ct_total_distance - current_distance_beetween_check_points) > stx_commons.distance_beetween_check_points) {
										current_distance_beetween_check_points = (int) Math
												.floor(stx_calculations.ct_total_distance);
										// Captura todos los puntos que puedas
										// para tener una max reloucion para
										// checkpoints
										// puntos en tracking interno para
										// deteccion de checkpoints
										// +++ A�ade a la lista de puntos en
										// checkpoint visible
										stx_commons.checkPointsArray
												.add(new_Geopoint);

										ShapeOnTrackOverlay checkpointArea = new ShapeOnTrackOverlay(
												progressbar_maps_Activity.this,
												new_Geopoint,
												location.getAccuracy());
										mapView.getOverlays().add(
												checkpointArea);
										mapView.invalidate();

									}

									// Add to LASTPOINT
									last_Geopoint = new_Geopoint;
								}

							} else {
								// stx_commons.geoPointsArray.add(new
								// geopoint_info(new_Geopoint));
								// Es nuestro primer geopoint de la captura
								MarkerOnTrackOverlay marker = new MarkerOnTrackOverlay(
										new_Geopoint,
										progressbar_maps_Activity.this,
										R.drawable.pin_start, 14);
								mapView.getOverlays().add(marker);
								mapView.invalidate();

								// Add to LASTPOINT
								last_Geopoint = new_Geopoint;
							}
						}

					} else {
						// Si hay mala señal GPS i aun no hemos empezado el
						// tracking deshabilita el botton
						if (!stx_commons.is_start_tracking) {
							button_start_tracking
									.setImageResource(R.drawable.tracking_record_0_dis);
							button_start_tracking.setClickable(false);
						}
					}

				}

			}

			public void onStatusChanged(String provider, int status,
					Bundle extras) {
				// TODO Auto-generated method stub
			}

			public void onProviderEnabled(String provider) {
				// TODO Auto-generated method stub

			}

			public void onProviderDisabled(String provider) {
				// TODO Auto-generated method stub

			}

		};

		// LINEAS OBLIGATIORIES PER A ACTUALITZAR EL SERVEI DE LOCALITZACIÓ

		stx_GPS.locationManager.requestLocationUpdates(
				LocationManager.GPS_PROVIDER, 0, 0, locationListener);
		stx_GPS.locationManager.requestLocationUpdates(
				LocationManager.NETWORK_PROVIDER, 0, 0, locationListener);

		// LocationManager locationManager =
		// (LocationManager)getSystemService(LOCATION_SERVICE);

	}

	@Override
	protected boolean isRouteDisplayed() {
		return false;
	}

	public void onSensorChanged(SensorEvent event) {

		if (event.sensor.getType() == mSensorManager.getDefaultSensor(
				Sensor.TYPE_ORIENTATION).getType()) {

			float degree = Math.round(event.values[0]);
			Log.v("ORIENTATION", "Orientació:" + Float.toString(degree)
					+ " graus");
			// create a rotation animation (reverse turn degree degrees)
			RotateAnimation ra = new RotateAnimation(grausActuals, -degree,
					Animation.RELATIVE_TO_SELF, 0.5f,
					Animation.RELATIVE_TO_SELF, 0.5f);

			// how long the animation will take place
			ra.setDuration(210);

			// set the animation after the end of the reservation status
			ra.setFillAfter(true);

			// Start the animation
			arrow.startAnimation(ra);
			grausActuals = -degree;

		}

		else if (event.sensor.getType() == mSensorAccel.getDefaultSensor(
				Sensor.TYPE_ACCELEROMETER).getType()) {

			if ((Math.sqrt((event.values[0] * event.values[0])
					+ (event.values[1] * event.values[1])
					+ (event.values[2] * event.values[2])))
					/ SensorManager.GRAVITY_EARTH > stx_commons.GFORCE) {
				double x = event.values[0] * event.values[0];
				double y = event.values[1] * event.values[1];
				double z = event.values[2] * event.values[2];

				double forceG = Math.sqrt(x + y + z);
				forceG = forceG / SensorManager.GRAVITY_EARTH;

				// TOP // - CÀLCUL DE LA FORÇA G.

				Location location = stx_GPS.locationManager
						.getLastKnownLocation(LocationManager.GPS_PROVIDER);

				GeoPoint geoNow = new GeoPoint(
						(int) (location.getLatitude() * 1E6),
						(int) (location.getLongitude() * 1E6)); // CREACIÓ DEL
																// GEOPOINT
																// POSICIÓ
																// ACTUAL
				gp = new geopoint_info(x, y, z, geoNow, grausActuals, forceG); // CREACIÓ
																				// DEL
																				// GEOPOINT_INFO
																				// INCLUINT
																				// LA
																				// FORÇA
																				// G.
				stx_commons.geoPointsArray.add(gp); // AFEGIM EL GEOPOINT A
													// L'ARRAY.

				// MARCA DEL GEOP ANTERIOR AL MAPA

				MarkerOnTrackOverlay marker = new MarkerOnTrackOverlay(
						gp.geopoint, progressbar_maps_Activity.this,
						R.drawable.icon_salt, 14);
				mapView.getOverlays().add(marker);
				mapView.invalidate();

				// Mostra del toast
				Toast toast = new Toast(this);
				toast.makeText(this, "SALT REGISTRAT", Toast.LENGTH_SHORT)
						.show();

			}

		}

	}

	public void onAccuracyChanged(Sensor sensor, int accuracy) {
		// TODO Auto-generated method stub

	}

	@Override
	protected void onPause() {
		super.onPause();

		// Log.v("NOTA", "Estic pausat");

	}

	@Override
	protected void onResume() {
		super.onResume();

		mSensorManager.registerListener(this,
				mSensorManager.getDefaultSensor(Sensor.TYPE_ORIENTATION),
				SensorManager.SENSOR_DELAY_GAME);
		mSensorAccel.registerListener(this,
				mSensorAccel.getDefaultSensor(Sensor.TYPE_ACCELEROMETER),
				SensorManager.SENSOR_DELAY_GAME);

	}

}