/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.internal;

import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.util.DisplayMetrics;
import android.view.View;
import android.webkit.DownloadListener;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.google.ads.AdActivity;
import com.google.ads.AdSize;
import com.google.ads.m;
import com.google.ads.util.AdUtil;
import com.google.ads.util.b;
import com.google.ads.util.g;
import com.google.ads.util.h;
import java.lang.ref.WeakReference;

public class AdWebView
extends WebView {
    private WeakReference<AdActivity> a;
    private AdSize b;
    private boolean c;
    private boolean d;
    private boolean e;

    public AdWebView(m slotState, AdSize adSize) {
        super(slotState.f.a());
        this.b = adSize;
        this.a = null;
        this.c = false;
        this.d = false;
        this.e = false;
        this.setBackgroundColor(0);
        AdUtil.a(this);
        WebSettings webSettings = this.getSettings();
        webSettings.setSupportMultipleWindows(false);
        webSettings.setJavaScriptEnabled(true);
        webSettings.setSavePassword(false);
        this.setDownloadListener(new DownloadListener(){

            public void onDownloadStart(String url, String userAgent, String contentDisposition, String mimeType, long size) {
                try {
                    Intent intent = new Intent("android.intent.action.VIEW");
                    intent.setDataAndType(Uri.parse((String)url), mimeType);
                    AdActivity adActivity = AdWebView.this.d();
                    if (adActivity != null && AdUtil.a(intent, (Context)adActivity)) {
                        adActivity.startActivity(intent);
                    }
                }
                catch (ActivityNotFoundException activityNotFoundException) {
                    com.google.ads.util.b.a("Couldn't find an Activity to view url/mimetype: " + url + " / " + mimeType);
                }
                catch (Throwable throwable) {
                    com.google.ads.util.b.b("Unknown error trying to start activity to view URL: " + url, throwable);
                }
            }
        });
        if (AdUtil.a >= 11) {
            g.a(webSettings, slotState);
        }
        this.setScrollBarStyle(0x2000000);
        if (AdUtil.a >= 14) {
            this.setWebChromeClient(new h.a(slotState));
        } else if (AdUtil.a >= 11) {
            this.setWebChromeClient(new g.a(slotState));
        }
    }

    public void a() {
        AdActivity adActivity = this.d();
        if (adActivity != null) {
            adActivity.finish();
        }
    }

    public void b() {
        if (AdUtil.a >= 11) {
            g.a((View)this);
        }
        this.d = true;
    }

    public void c() {
        if (this.d && AdUtil.a >= 11) {
            g.b((View)this);
        }
        this.d = false;
    }

    public AdActivity d() {
        return this.a != null ? (AdActivity)((Object)this.a.get()) : null;
    }

    public boolean e() {
        return this.e;
    }

    public boolean f() {
        return this.d;
    }

    public void setAdActivity(AdActivity adActivity) {
        this.a = new WeakReference<AdActivity>(adActivity);
    }

    public void loadDataWithBaseURL(String baseUrl, String data, String mimeType, String encoding, String historyUrl) {
        try {
            super.loadDataWithBaseURL(baseUrl, data, mimeType, encoding, historyUrl);
        }
        catch (Throwable throwable) {
            com.google.ads.util.b.b("An error occurred while loading data in AdWebView:", throwable);
        }
    }

    public void loadUrl(String url) {
        try {
            super.loadUrl(url);
        }
        catch (Throwable throwable) {
            com.google.ads.util.b.b("An error occurred while loading a URL in AdWebView:", throwable);
        }
    }

    public void stopLoading() {
        try {
            super.stopLoading();
        }
        catch (Throwable throwable) {
            com.google.ads.util.b.d("An error occurred while stopping loading in AdWebView:", throwable);
        }
    }

    public void destroy() {
        try {
            super.destroy();
            this.setWebViewClient(new WebViewClient());
        }
        catch (Throwable throwable) {
            com.google.ads.util.b.b("An error occurred while destroying an AdWebView:", throwable);
        }
    }

    public synchronized void setAdSize(AdSize adSize) {
        this.b = adSize;
        this.requestLayout();
    }

    protected synchronized void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (this.isInEditMode()) {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
            return;
        }
        if (this.b == null || this.c) {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
            return;
        }
        int n2 = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int n3 = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int n4 = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int n5 = View.MeasureSpec.getSize((int)heightMeasureSpec);
        DisplayMetrics displayMetrics = this.getContext().getResources().getDisplayMetrics();
        float f2 = displayMetrics.density;
        int n6 = (int)((float)this.b.getWidth() * f2);
        int n7 = (int)((float)this.b.getHeight() * f2);
        int n8 = Integer.MAX_VALUE;
        if (n2 == Integer.MIN_VALUE || n2 == 0x40000000) {
            n8 = n3;
        }
        int n9 = Integer.MAX_VALUE;
        if (n4 == Integer.MIN_VALUE || n4 == 0x40000000) {
            n9 = n5;
        }
        if ((float)n6 - 6.0f * f2 > (float)n8 || n7 > n9) {
            com.google.ads.util.b.e("Not enough space to show ad! Wants: <" + n6 + ", " + n7 + ">, Has: <" + n3 + ", " + n5 + ">");
            this.setVisibility(8);
            this.setMeasuredDimension(n3, n5);
        } else {
            this.setMeasuredDimension(n6, n7);
        }
    }

    public void setCustomClose(boolean useCustomClose) {
        AdActivity adActivity;
        this.e = useCustomClose;
        if (this.a != null && (adActivity = (AdActivity)((Object)this.a.get())) != null) {
            adActivity.setCustomClose(useCustomClose);
        }
    }

    public void setIsExpandedMraid(boolean isCurrentlyExpandedMraid) {
        this.c = isCurrentlyExpandedMraid;
    }
}

