/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sanselan.formats.jpeg.segments;

import java.io.IOException;
import java.io.InputStream;
import org.apache.sanselan.ImageReadException;
import org.apache.sanselan.formats.jpeg.segments.Segment;

public class SOFNSegment
extends Segment {
    public final int width;
    public final int height;
    public final int Number_of_components;
    public final int Precision;

    public SOFNSegment(int marker, int marker_length, InputStream is) throws ImageReadException, IOException {
        super(marker, marker_length);
        if (this.getDebug()) {
            System.out.println("SOF0Segment marker_length: " + marker_length);
        }
        this.Precision = this.readByte("Data_precision", is, "Not a Valid JPEG File");
        this.height = this.read2Bytes("Image_height", is, "Not a Valid JPEG File");
        this.width = this.read2Bytes("Image_Width", is, "Not a Valid JPEG File");
        this.Number_of_components = this.readByte("Number_of_components", is, "Not a Valid JPEG File");
        this.skipBytes(is, marker_length - 6, "Not a Valid JPEG File: SOF0 Segment");
        if (this.getDebug()) {
            System.out.println("");
        }
    }

    public String getDescription() {
        return "SOFN (SOF" + (this.marker - 65472) + ") (" + this.getSegmentType() + ")";
    }
}

