/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sanselan.formats.png;

public class GammaCorrection {
    private static final boolean DEBUG = false;
    private final int[] lookup_table = new int[256];

    public GammaCorrection(double src_gamma, double dst_gamma) {
        for (int i = 0; i < 256; ++i) {
            this.lookup_table[i] = this.correctSample(i, src_gamma, dst_gamma);
        }
    }

    public int correctSample(int sample) {
        return this.lookup_table[sample];
    }

    public int correctARGB(int pixel) {
        int alpha = 0xFF000000 & pixel;
        int red = (pixel & 0xFF) >> 16;
        int green = (pixel & 0xFF) >> 8;
        int blue = (pixel & 0xFF) >> 0;
        red = this.correctSample(red);
        green = this.correctSample(green);
        blue = this.correctSample(blue);
        int rgb = alpha | (0xFF & red) << 16 | (0xFF & green) << 8 | (0xFF & blue) << 0;
        return rgb;
    }

    private int correctSample(int sample, double src_gamma, double dst_gamma) {
        return (int)Math.round(255.0 * Math.pow((double)sample / 255.0, src_gamma / dst_gamma));
    }
}

