/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sanselan.formats.tiff.photometricinterpreters;

import java.awt.image.BufferedImage;
import java.io.IOException;
import org.apache.sanselan.ImageReadException;
import org.apache.sanselan.formats.tiff.photometricinterpreters.PhotometricInterpreter;

public class PhotometricInterpreterLogLUV
extends PhotometricInterpreter {
    private final boolean yOnly;

    public PhotometricInterpreterLogLUV(int fSamplesPerPixel, int[] fBitsPerSample, int Predictor, int width, int height, boolean yonly) {
        super(fSamplesPerPixel, fBitsPerSample, Predictor, width, height);
        this.yOnly = yonly;
    }

    public void dumpstats() throws ImageReadException, IOException {
    }

    private float cube(float f) {
        return f * f * f;
    }

    public void interpretPixel(BufferedImage bi, int[] samples, int x, int y) throws ImageReadException, IOException {
        int cieL = samples[0];
        byte cieA = (byte)samples[1];
        byte cieB = (byte)samples[2];
        float var_Y = ((float)cieL * 100.0f / 255.0f + 16.0f) / 116.0f;
        float var_X = (float)cieA / 500.0f + var_Y;
        float var_Z = var_Y - (float)cieB / 200.0f;
        float var_x_cube = this.cube(var_X);
        float var_y_cube = this.cube(var_Y);
        float var_z_cube = this.cube(var_Z);
        var_Y = var_y_cube > 0.008856f ? var_y_cube : (var_Y - 0.13793103f) / 7.787f;
        var_X = var_x_cube > 0.008856f ? var_x_cube : (var_X - 0.13793103f) / 7.787f;
        var_Z = var_z_cube > 0.008856f ? var_z_cube : (var_Z - 0.13793103f) / 7.787f;
        float ref_X = 95.047f;
        float ref_Y = 100.0f;
        float ref_Z = 108.883f;
        float X = ref_X * var_X;
        float Y = ref_Y * var_Y;
        float Z = ref_Z * var_Z;
        float var_X2 = X / 100.0f;
        float var_Y2 = Y / 100.0f;
        float var_Z2 = Z / 100.0f;
        float var_R = var_X2 * 3.2406f + var_Y2 * -1.5372f + var_Z2 * -0.4986f;
        float var_G = var_X2 * -0.9689f + var_Y2 * 1.8758f + var_Z2 * 0.0415f;
        float var_B = var_X2 * 0.0557f + var_Y2 * -0.204f + var_Z2 * 1.057f;
        var_R = (double)var_R > 0.0031308 ? 1.055f * (float)Math.pow(var_R, 0.4166666666666667) - 0.055f : 12.92f * var_R;
        var_G = (double)var_G > 0.0031308 ? 1.055f * (float)Math.pow(var_G, 0.4166666666666667) - 0.055f : 12.92f * var_G;
        var_B = (double)var_B > 0.0031308 ? 1.055f * (float)Math.pow(var_B, 0.4166666666666667) - 0.055f : 12.92f * var_B;
        int R = (int)(var_R * 255.0f);
        int G = (int)(var_G * 255.0f);
        int B = (int)(var_B * 255.0f);
        int red = R;
        int green = G;
        int blue = B;
        red = Math.min(255, Math.max(0, red));
        green = Math.min(255, Math.max(0, green));
        blue = Math.min(255, Math.max(0, blue));
        int alpha = 255;
        int rgb = alpha << 24 | red << 16 | green << 8 | blue << 0;
        bi.setRGB(x, y, rgb);
    }
}

