package com.commons;

import org.anddev.andengine.engine.Engine;
import org.anddev.andengine.entity.modifier.ScaleModifier;
import org.anddev.andengine.entity.scene.Scene;
import org.anddev.andengine.entity.sprite.Sprite;
import org.anddev.andengine.opengl.texture.TextureOptions;
import org.anddev.andengine.opengl.texture.atlas.bitmap.BitmapTextureAtlas;
import org.anddev.andengine.opengl.texture.atlas.bitmap.BitmapTextureAtlasTextureRegionFactory;
import org.anddev.andengine.opengl.texture.region.TextureRegion;
import org.anddev.andengine.ui.activity.BaseGameActivity;

import com.loading.loading_progressbar;
import com.perpixelperfectcollision.*;

public class game_commons {
	
	public static Engine gEngine;
	public static BaseGameActivity gActivity;
	public static Scene gScene;
	
	// Centro de la pantalla
	public static float screen_center_point_X=0;
	public static float screen_center_point_Y=0;
	
	public static final int sprite_map_with=1024;
	public static final int sprite_map_height=1024;
	
	public static float cVelocity = 100.0f;	

	public static BitmapTextureAtlas Loading_textureatlas = new BitmapTextureAtlas(sprite_map_with, sprite_map_height,TextureOptions.BILINEAR_PREMULTIPLYALPHA);	
	public static BitmapTextureAtlas Menu_Background_textureatlas = new BitmapTextureAtlas(sprite_map_with, sprite_map_height,TextureOptions.BILINEAR_PREMULTIPLYALPHA);	 
	public static BitmapTextureAtlas AnimalChain_Main_textureatlas = new BitmapTextureAtlas(game_commons.sprite_map_with, game_commons.sprite_map_height,TextureOptions.BILINEAR_PREMULTIPLYALPHA);	

	
	public static TextureRegion Loading_background;
	public static TextureRegion Loading_background1;
	public static TextureRegion Loading_background2;
	
	public static TextureRegion Loading_text;
	public static loading_progressbar Loading_progress_bar;
	
	// Resolucion maxima del dispositivo
	// Creamos variables para definir sobre que resolucion vamos a trabajar 
	// Resolucions acceptades 480,320
	public static float cCamera_width = 0.0f;
	public static float cCamera_height = 0.0f;
	
	public static int id_counter=-1;

	public static TextureRegion loadBackground(BitmapTextureAtlas current_SpriteMap,BaseGameActivity oactivity,String tpath,int initial_posX_SpriteMap,int initial_posY_SpriteMap)
	{   
		return BitmapTextureAtlasTextureRegionFactory.createFromAsset(current_SpriteMap, oactivity,  tpath, initial_posX_SpriteMap,initial_posY_SpriteMap);
	}
	
	public static PixelPerfectTiledTextureRegion loadToSpriteMap(BitmapTextureAtlas current_SpriteMap,String tpath,int initial_posX_SpriteMap,int initial_posY_SpriteMap,int total_cols,int total_rows,BaseGameActivity oactivity)
	{   
		// Ponemos la relacion de imagenes de la animacion en el sprite map comun
		PixelPerfectTiledTextureRegion tTex= PixelPerfectTextureRegionFactory.createTiledFromAsset(current_SpriteMap, oactivity, tpath,initial_posX_SpriteMap, initial_posY_SpriteMap, total_cols ,total_rows);
	    return tTex;
	}

	
	public static int get_id()
	{
		id_counter=id_counter+1;
		return id_counter;
	}
	
	
	public static ScaleModifier getBackgroundScaleResolution(Sprite tsprite)
	{
		final float xScale = (game_commons.cCamera_width/tsprite.getWidth());
		final float yScale = (game_commons.cCamera_height/tsprite.getHeight());
		return new ScaleModifier(1f, 1.0f, xScale, 1.0f, yScale);
	}
}

