package com.main;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Random;

import javax.microedition.khronos.opengles.GL10;

import org.anddev.andengine.audio.music.Music;
import org.anddev.andengine.audio.music.MusicFactory;
import org.anddev.andengine.engine.Engine;
import org.anddev.andengine.engine.camera.ZoomCamera;
import org.anddev.andengine.engine.handler.IUpdateHandler;
import org.anddev.andengine.engine.options.EngineOptions;
import org.anddev.andengine.engine.options.EngineOptions.ScreenOrientation;
import org.anddev.andengine.engine.options.resolutionpolicy.FillResolutionPolicy;
import org.anddev.andengine.entity.scene.Scene;
import org.anddev.andengine.entity.scene.Scene.IOnSceneTouchListener;
import org.anddev.andengine.entity.sprite.AnimatedSprite;
import org.anddev.andengine.entity.sprite.Sprite;
import org.anddev.andengine.entity.util.FPSLogger;
import org.anddev.andengine.input.touch.TouchEvent;
import org.anddev.andengine.input.touch.detector.ScrollDetector;
import org.anddev.andengine.input.touch.detector.SurfaceScrollDetector;
import org.anddev.andengine.input.touch.detector.ScrollDetector.IScrollDetectorListener;
import org.anddev.andengine.opengl.texture.TextureOptions;
import org.anddev.andengine.opengl.texture.atlas.bitmap.BitmapTextureAtlas;
import org.anddev.andengine.opengl.texture.atlas.bitmap.BitmapTextureAtlasTextureRegionFactory;
import org.anddev.andengine.opengl.texture.region.TextureRegion;
import org.anddev.andengine.opengl.texture.region.TiledTextureRegion;
import org.anddev.andengine.opengl.util.GLHelper;
import org.anddev.andengine.ui.activity.LayoutGameActivity;
import org.anddev.andengine.util.Debug;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;

import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.KeyEvent;

import com.bc_demo.R;
import com.commons.game_commons;
import com.engine.AsyncTaskLoader;
import com.engine.IAsyncCallback;
import com.engine.SpriteChain;



import com.menu.*;
import com.loading.loading_progressbar;
import com.sound.game_mediaplayerEx;

public class progressbar_menu_Activity extends LayoutGameActivity implements IScrollDetectorListener, IOnSceneTouchListener  
{
  	@SuppressWarnings("deprecation")
	
	private ZoomCamera mCamera;
	private SurfaceScrollDetector mScrollDetector;
	
	public Scene loadscene;
	public Sprite lbackground;
	
	protected Scene MenuScene = new Scene(1);
	private TextureRegion Menu_background;

	public String menu_path="images/menus_high/";
	
	private Music mMusic;
	// SPRITE
	private BitmapTextureAtlas explosionAtlas = new BitmapTextureAtlas(512, 512,TextureOptions.BILINEAR_PREMULTIPLYALPHA);	
	private TextureRegion explosionTRegion;
	// ANIMATED SPRITE
	private BitmapTextureAtlas animatedExplosionAtlas = new BitmapTextureAtlas(1024, 1024,TextureOptions.BILINEAR_PREMULTIPLYALPHA);	
	private TiledTextureRegion animatedExplosionTRegion;
	
	// +++++++++++++++++
	// +++ ADS CODE ++++
	// +++++++++++++++++
	@Override
    protected int getLayoutID() {
            return R.layout.main;
    }

    @Override
    protected int getRenderSurfaceViewID() {
            return R.id.ads_adMob;
    }

    
	// Definicion de objetos del motor AndEngine
	public Engine onLoadEngine() 
	{			 
        game_commons.cCamera_width=1024.0f;
        game_commons.cCamera_height=600.0f;
	
        // Calculamos el centro de la pantalla todos los objetos depanden de ello
        game_commons.screen_center_point_X=(game_commons.cCamera_width/2);
        game_commons.screen_center_point_Y=(game_commons.cCamera_height/2);
        
		this.mCamera = new ZoomCamera(0, 0, game_commons.cCamera_width , game_commons.cCamera_height );
		this.mCamera.setBounds(0, game_commons.cCamera_width, 0, game_commons.cCamera_height);
		this.mCamera.setBoundsEnabled(true);

		return new Engine(new EngineOptions(true, ScreenOrientation.LANDSCAPE, new FillResolutionPolicy(), this.mCamera).setNeedsMusic(true).setNeedsSound(true));
	}
	
	// Carga i asignacion de texturas i objetos.
	public void onLoadResources() 
	{
		game_commons.gEngine=this.mEngine;
		game_commons.gActivity=this;

		game_commons.Loading_background = BitmapTextureAtlasTextureRegionFactory.createFromAsset(game_commons.Loading_textureatlas, this, menu_path+"loading_background_2.png", 0, 0); // 1024x640
		game_commons.Loading_progress_bar = new loading_progressbar(game_commons.screen_center_point_X-50, game_commons.screen_center_point_Y-70, game_commons.loadToSpriteMap(game_commons.Loading_textureatlas,menu_path+"loading_progress.png", 0, 641, 1, 1, this),this,1,this.mEngine,100,100,1,1,false); //100x100
		game_commons.Loading_text = BitmapTextureAtlasTextureRegionFactory.createFromAsset(game_commons.Loading_textureatlas, this, menu_path+"loading_text.png", 0, 740); // 1024x600
		this.mEngine.getTextureManager().loadTextures(game_commons.Loading_textureatlas);
	}

	@SuppressWarnings("deprecation")
	public Scene onLoadScene() 
	{
        this.mEngine.registerUpdateHandler(new FPSLogger());

        loadscene = new Scene(1);
        loadscene.setBackgroundEnabled(false);
        game_commons.Loading_background.setTextureRegionBufferManaged(false);
        
        // REPARA BUG THE LINIES EN EL BACKGROUND 
        lbackground = new Sprite(0,0,game_commons.Loading_background) {
            protected void onInitDraw(final GL10 pGL)
            {
               super.onInitDraw(pGL);
               GLHelper.enableTextures(pGL);
               GLHelper.enableTexCoordArray(pGL);
               GLHelper.enableDither(pGL);
            }
        };
        
        lbackground.registerEntityModifier(game_commons.getBackgroundScaleResolution(lbackground));
        lbackground.detachSelf();
        loadscene.attachChild(lbackground);
		 
        loadscene.attachChild(new Sprite(game_commons.Loading_progress_bar.getX(), game_commons.Loading_progress_bar.getY()+102, game_commons.Loading_text));
        loadscene.attachChild(game_commons.Loading_progress_bar);		
        
        // ***************** IAsyncCallback ****************************
		IAsyncCallback callback = new IAsyncCallback() {
 
			public void workToDo() 
			{
				load_resources_scene();
			}
 
			public void onComplete() 
			{
				     unload_loadingscene();
				     mEngine.setScene(MenuScene);
	
			}
		};
		new AsyncTaskLoader().execute(callback);

  		// Deixem un petit retard per que acabi de fer en scale del background
        return loadscene;
     
	}

	public void onLoadComplete() 
	{

	}
	
	public void onPause()
	{
		 super.onPause();
		 try{
			 	mMusic.pause();
		 }
		 catch(NullPointerException e){
			 
		 }
		
	}
	
	public void onResume()
	{
		super.onResume();
		 try{
			 if (mMusic!=null) mMusic.resume();
		 }
		 catch(NullPointerException e){
			 
		 }
	}
	
	private void unload_loadingscene()
	{
	   
			this.runOnUpdateThread(new Runnable() 
			{
	            public void run() 
	            {
					game_commons.Loading_progress_bar.detachSelf();
	            }
	         });
		
	}
 
 
	/**
	 * This is called when assets need to be loaded in the background.
	 */
	protected void load_resources_scene() 
	{
		 /*********************************  CARREGA MUSIC *************************************/
		
		MusicFactory.setAssetBasePath("music/");
        try {
                this.mMusic=MusicFactory.createMusicFromAsset(this.mEngine.getMusicManager(), this, "menu_background.ogg");
                this.mMusic.setLooping(true);
                
        } catch (final IOException e) {
                Debug.e("Error", e);
        }

        explosionTRegion = BitmapTextureAtlasTextureRegionFactory.createFromAsset(
        		explosionAtlas, 
        		this, menu_path+"explosion.png", 
        		0,
        		0); // 1024x640
        
        animatedExplosionTRegion=game_commons.loadToSpriteMap(animatedExplosionAtlas,menu_path+"animatedexplosion.png", 0,0, 9, 9, this);
        
		
		// Cargamos el sprite map
		this.mEngine.getTextureManager().loadTextures(game_commons.Menu_Background_textureatlas,game_commons.AnimalChain_Main_textureatlas,explosionAtlas,animatedExplosionAtlas);
		this.mEngine.getTextureManager().reloadTextures();
		
		Sprite explosion = new Sprite(100,100,explosionTRegion);
		AnimatedSprite aexplosion = new AnimatedSprite(300,200,animatedExplosionTRegion);
		aexplosion.setScale(5.0f);
		aexplosion.animate(30,true);
		 // ************************ BACKGROUND DECLARATION ******************************************
		// Objeto animado
		// Creamos objetos de juego con is_animated a true.
		// Li passem el objecte que controla el boto
		Menu_background = BitmapTextureAtlasTextureRegionFactory.createFromAsset(game_commons.Menu_Background_textureatlas, this, menu_path+"menu_background_2.png", 0, 0); // 1024x640

		MenuScene.setBackgroundEnabled(false);
		
		 // REPARA BUG THE LINIES EN EL BACKGROUND
        Sprite mbackground = new Sprite(0,0,Menu_background) {
            protected void onInitDraw(final GL10 pGL)
            {
               super.onInitDraw(pGL);
               GLHelper.enableTextures(pGL);
               GLHelper.enableTexCoordArray(pGL);
               GLHelper.enableDither(pGL);
            }
        };
        
		mbackground.registerEntityModifier(game_commons.getBackgroundScaleResolution(mbackground));
		
		// Deixem un petit retard per que acabi de fer en scale del background
		try 
		{
		 Thread.sleep(300);
		} 
		catch (InterruptedException e) 
		{
		  e.printStackTrace();
		}
		
		mbackground.detachSelf();
		MenuScene.attachChild(mbackground);
		// ************************ FIN BACKGROUND DECLARATION ******************************************
		
		MenuScene.setOnAreaTouchTraversalFrontToBack();
		   
		// Aadimos manejador de Scroll
		this.mScrollDetector = new SurfaceScrollDetector(this);
		this.mScrollDetector.setEnabled(true);

		// Aadimos manejador de Touch de la pantalla
		MenuScene.setOnSceneTouchListener(this);
		MenuScene.setTouchAreaBindingEnabled(true);
		
		// ***************** PLAY MUSIC *****************************
	    try
	    {
	    	 if(this.mMusic!=null && this.mMusic.isPlaying())
	    	 {
	    		 this.mMusic.stop();
	    		 this.mMusic.release();
	    	 }
	    	 else
	    	 {
	    		 this.mMusic.play();
	    	 }
	    }
	    catch(Exception e)
	    {
	    	
	    }

	    MenuScene.attachChild(explosion);
	    MenuScene.attachChild(aexplosion);
	    
	}

	public void onScroll(ScrollDetector pScrollDetector, TouchEvent pTouchEvent,float pDistanceX, float pDistanceY) 
	{
		
	}
	
	// Evento que se desencadena al tocar la pantalla
	public boolean onSceneTouchEvent(Scene pScene, TouchEvent pSceneTouchEvent) 
	{
		
		this.mScrollDetector.onTouchEvent(pSceneTouchEvent);
		return true;
	}	

	// Important cal possar-ho per no generar instancies cada vegada que toquem el home button i tornem al joc
	public void onCreate(Bundle b)
	{
		super.onCreate(b);
	}
	
	// Deteccio de activity actual en segon pla
	public void onUserLeaveHint()
	{
		
	}
	
	public boolean onKeyDown(final int pKeyCode,final KeyEvent pEvent)
	{
		if(pKeyCode==82 || pKeyCode==84 || pKeyCode==2 || pKeyCode == KeyEvent.KEYCODE_BACK)
		{
			showExitDialog();
			return true;
		}
		return super.onKeyDown(pKeyCode, pEvent);
	}
	
	public void showExitDialog()
	{
		
		AlertDialog.Builder builder = new AlertDialog.Builder(progressbar_menu_Activity.this);
		
		builder.setMessage(":: Do you want to exit game? ::").setCancelable(false).setTitle(":: Exit key detected! ::")
		
		.setPositiveButton(" Yes please! ", 
				new DialogInterface.OnClickListener() {
						public void onClick(DialogInterface dialog,int id){
							System.exit(0);
							//progressbar_game_Activity.this.finish();
						}
		})
		
		.setNegativeButton(" Oops NO!  ", 
				new DialogInterface.OnClickListener() {
						public void onClick(DialogInterface dialog,int id){
							dialog.cancel();
						}
		});
		
		AlertDialog alert = builder.create();
		alert.setIcon(android.R.drawable.ic_dialog_alert);
		alert.show();

	}

	public game_mediaplayerEx load_sound(game_mediaplayerEx tsound,String tpath)
	{
		   try
	        {
			   tsound.setDataSourceFromAsset(this.getAssets(), tpath);
			   tsound.prepareAsync();
			   tsound.setLooping(false);
	        }
	        catch (IOException e)
	        {
	        	tsound.release();
	        	tsound = null;
	            e.printStackTrace();
	        }
		   return tsound;
	}

}




