/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sanselan.formats.jpeg.segments;

import java.io.IOException;
import java.io.InputStream;
import org.apache.sanselan.ImageReadException;
import org.apache.sanselan.formats.jpeg.segments.Segment;

public class JFIFSegment
extends Segment {
    public final int JFIF_major_version;
    public final int JFIF_minor_version;
    public final int density_units;
    public final int xDensity;
    public final int yDensity;
    public final int xThumbnail;
    public final int yThumbnail;
    public final int thumbnailSize;
    private static final byte[] JFIF0_SIGNATURE = new byte[]{74, 70, 73, 70, 0};

    public String getDescription() {
        return "JFIF (" + this.getSegmentType() + ")";
    }

    public JFIFSegment(int marker, int marker_length, InputStream is) throws ImageReadException, IOException {
        super(marker, marker_length);
        this.readAndVerifyBytes(is, JFIF0_SIGNATURE, "Not a Valid JPEG File: missing JFIF string");
        this.JFIF_major_version = this.readByte("JFIF_major_version", is, "Not a Valid JPEG File");
        this.JFIF_minor_version = this.readByte("JFIF_minor_version", is, "Not a Valid JPEG File");
        this.density_units = this.readByte("density_units", is, "Not a Valid JPEG File");
        this.xDensity = this.read2Bytes("x_density", is, "Not a Valid JPEG File");
        this.yDensity = this.read2Bytes("y_density", is, "Not a Valid JPEG File");
        this.xThumbnail = this.readByte("x_thumbnail", is, "Not a Valid JPEG File");
        this.yThumbnail = this.readByte("y_thumbnail", is, "Not a Valid JPEG File");
        this.thumbnailSize = this.xThumbnail * this.yThumbnail;
        if (this.thumbnailSize > 0) {
            this.skipBytes(is, this.thumbnailSize, "Not a Valid JPEG File: missing thumbnail");
        }
        if (this.getDebug()) {
            System.out.println("");
        }
    }
}

