/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sanselan.formats.tiff.write;

import java.io.IOException;
import org.apache.sanselan.ImageWriteException;
import org.apache.sanselan.common.BinaryOutputStream;
import org.apache.sanselan.formats.tiff.TagInfo;
import org.apache.sanselan.formats.tiff.fieldtypes.FieldType;

public class WriteField {
    public final TagInfo tagInfo;
    public final FieldType fieldType;
    public final int count;
    public byte[] bytes;

    public WriteField(TagInfo tag, FieldType tagtype, int count, byte[] bytes) {
        this.tagInfo = tag;
        this.fieldType = tagtype;
        this.count = count;
        this.bytes = bytes;
    }

    public int writeDirectoryEntry(BinaryOutputStream bos, int seperateValuesOffset) throws ImageWriteException, IOException {
        bos.write2Bytes(this.tagInfo.tag);
        bos.write2Bytes(this.fieldType.type);
        bos.write4Bytes(this.count);
        if (this.bytes.length <= 4) {
            bos.writeByteArray(this.bytes);
            int remainder = 4 - this.bytes.length;
            for (int i = 0; i < remainder; ++i) {
                bos.write(0);
            }
            return 0;
        }
        bos.write4Bytes(seperateValuesOffset);
        int written = this.bytes.length;
        if (written % 2 != 0) {
            ++written;
        }
        return written;
    }

    public int getSeperateValueLength() {
        if (this.bytes.length <= 4) {
            return 0;
        }
        int written = this.bytes.length;
        if (written % 2 != 0) {
            ++written;
        }
        return written;
    }

    public int writeSeperateValue(BinaryOutputStream bos) throws ImageWriteException, IOException {
        if (this.bytes.length <= 4) {
            return 0;
        }
        bos.writeByteArray(this.bytes);
        int written = this.bytes.length;
        if (written % 2 != 0) {
            bos.write(0);
            ++written;
        }
        return written;
    }

    public void setData(byte[] bytes) {
        this.bytes = bytes;
    }
}

