/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sanselan;

import java.awt.RenderingHints;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.ImagingOpException;
import java.io.File;
import java.io.IOException;
import org.apache.sanselan.ImageReadException;
import org.apache.sanselan.Sanselan;
import org.apache.sanselan.common.byteSources.ByteSource;
import org.apache.sanselan.common.byteSources.ByteSourceArray;
import org.apache.sanselan.common.byteSources.ByteSourceFile;

public class ColorTools {
    public BufferedImage correctImage(BufferedImage src, File file) throws ImageReadException, IOException {
        ICC_Profile icc = Sanselan.getICCProfile(file);
        if (icc == null) {
            return src;
        }
        ICC_ColorSpace cs = new ICC_ColorSpace(icc);
        BufferedImage dst = this.convertFromColorSpace(src, cs);
        return dst;
    }

    public BufferedImage correctImageX2(BufferedImage src, byte[] bytes) throws ImageReadException, IOException {
        return this.correctImageX2(src, new ByteSourceArray(bytes));
    }

    public BufferedImage correctImageX2(BufferedImage src, File file) throws ImageReadException, IOException {
        return this.correctImageX2(src, new ByteSourceFile(file));
    }

    public BufferedImage correctImageX2(BufferedImage src, ByteSource byte_source) throws ImageReadException, IOException {
        ICC_Profile icc = Sanselan.getICCProfile(byte_source);
        if (icc == null) {
            return src;
        }
        ICC_ColorSpace cs = new ICC_ColorSpace(icc);
        ColorSpace cs_sRGB = ColorSpace.getInstance(1000);
        BufferedImage dst = this.convertBetweenColorSpacesX2(src, cs, cs_sRGB);
        return dst;
    }

    public BufferedImage relabelColorSpace(BufferedImage bi, File file) throws ImagingOpException, ImageReadException, IOException {
        return this.relabelColorSpace(bi, new ByteSourceFile(file));
    }

    public BufferedImage relabelColorSpace(BufferedImage bi, byte[] bytes) throws ImagingOpException, ImageReadException, IOException {
        return this.relabelColorSpace(bi, new ByteSourceArray(bytes));
    }

    private final BufferedImage relabelColorSpace(BufferedImage bi, ByteSource byte_source) throws ImagingOpException, ImageReadException, IOException {
        ICC_Profile icc = Sanselan.getICCProfile(byte_source);
        if (icc == null) {
            return bi;
        }
        return this.relabelColorSpace(bi, icc);
    }

    public BufferedImage relabelColorSpace(BufferedImage bi, ICC_Profile profile) throws ImagingOpException {
        ICC_ColorSpace cs = new ICC_ColorSpace(profile);
        return this.relabelColorSpace(bi, cs);
    }

    public BufferedImage relabelColorSpace(BufferedImage bi, ColorSpace cs) throws ImagingOpException {
        ColorModel cm = this.deriveColorModel(bi, cs);
        return this.relabelColorSpace(bi, cm);
    }

    public BufferedImage relabelColorSpace(BufferedImage bi, ColorModel cm) throws ImagingOpException {
        BufferedImage result = new BufferedImage(cm, bi.getRaster(), false, null);
        return result;
    }

    public ColorModel deriveColorModel(BufferedImage bi, ColorSpace cs) throws ImagingOpException {
        return this.deriveColorModel(bi, cs, false);
    }

    public ColorModel deriveColorModel(BufferedImage bi, ColorSpace cs, boolean force_no_alpha) throws ImagingOpException {
        return this.deriveColorModel(bi.getColorModel(), cs, force_no_alpha);
    }

    public ColorModel deriveColorModel(ColorModel old_cm, ColorSpace cs, boolean force_no_alpha) throws ImagingOpException {
        if (old_cm instanceof ComponentColorModel) {
            ComponentColorModel ccm = (ComponentColorModel)old_cm;
            if (force_no_alpha) {
                return new ComponentColorModel(cs, false, false, 1, ccm.getTransferType());
            }
            return new ComponentColorModel(cs, ccm.hasAlpha(), ccm.isAlphaPremultiplied(), ccm.getTransparency(), ccm.getTransferType());
        }
        if (old_cm instanceof DirectColorModel) {
            DirectColorModel dcm = (DirectColorModel)old_cm;
            int old_mask = dcm.getRedMask() | dcm.getGreenMask() | dcm.getBlueMask() | dcm.getAlphaMask();
            int old_bits = this.count_bits_in_mask(old_mask);
            return new DirectColorModel(cs, old_bits, dcm.getRedMask(), dcm.getGreenMask(), dcm.getBlueMask(), dcm.getAlphaMask(), dcm.isAlphaPremultiplied(), dcm.getTransferType());
        }
        throw new ImagingOpException("Could not clone unknown ColorModel Type.");
    }

    private int count_bits_in_mask(int i) {
        int count = 0;
        while (i != 0) {
            count += i & 1;
            i >>>= 1;
        }
        return count;
    }

    public BufferedImage convertToColorSpace(BufferedImage bi, ColorSpace to) {
        ColorSpace from = bi.getColorModel().getColorSpace();
        RenderingHints hints = new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        hints.put(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        hints.put(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        ColorConvertOp op = new ColorConvertOp(from, to, hints);
        BufferedImage result = op.filter(bi, null);
        result = this.relabelColorSpace(result, to);
        return result;
    }

    public BufferedImage convertTosRGB(BufferedImage bi) {
        ColorSpace cs_sRGB = ColorSpace.getInstance(1000);
        ColorModel srgbCM = ColorModel.getRGBdefault();
        cs_sRGB = srgbCM.getColorSpace();
        return this.convertToColorSpace(bi, cs_sRGB);
    }

    protected BufferedImage convertFromColorSpace(BufferedImage bi, ColorSpace from) {
        ColorModel srgbCM = ColorModel.getRGBdefault();
        ColorSpace cs_sRGB = srgbCM.getColorSpace();
        return this.convertBetweenColorSpaces(bi, from, cs_sRGB);
    }

    public BufferedImage convertBetweenICCProfiles(BufferedImage bi, ICC_Profile from, ICC_Profile to) {
        ICC_ColorSpace cs_from = new ICC_ColorSpace(from);
        ICC_ColorSpace cs_to = new ICC_ColorSpace(to);
        return this.convertBetweenColorSpaces(bi, cs_from, cs_to);
    }

    public BufferedImage convertToICCProfile(BufferedImage bi, ICC_Profile to) {
        ICC_ColorSpace cs_to = new ICC_ColorSpace(to);
        return this.convertToColorSpace(bi, cs_to);
    }

    public BufferedImage convertBetweenColorSpacesX2(BufferedImage bi, ColorSpace from, ColorSpace to) {
        RenderingHints hints = new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        hints.put(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        hints.put(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        bi = this.relabelColorSpace(bi, from);
        ColorConvertOp op = new ColorConvertOp(from, to, hints);
        bi = op.filter(bi, null);
        bi = this.relabelColorSpace(bi, from);
        bi = op.filter(bi, null);
        bi = this.relabelColorSpace(bi, to);
        return bi;
    }

    public BufferedImage convertBetweenColorSpaces(BufferedImage bi, ColorSpace from, ColorSpace to) {
        RenderingHints hints = new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        hints.put(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        hints.put(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        ColorConvertOp op = new ColorConvertOp(from, to, hints);
        bi = this.relabelColorSpace(bi, from);
        BufferedImage result = op.filter(bi, null);
        result = this.relabelColorSpace(result, to);
        return result;
    }
}

