/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sanselan.formats.pnm;

import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.io.IOException;
import java.io.InputStream;
import org.apache.sanselan.ImageFormat;
import org.apache.sanselan.formats.pnm.WhiteSpaceReader;

public abstract class FileInfo {
    protected final int width;
    protected final int height;
    protected final boolean RAWBITS;

    public FileInfo(int width, int height, boolean RAWBITS) {
        this.width = width;
        this.height = height;
        this.RAWBITS = RAWBITS;
    }

    public abstract int getNumComponents();

    public abstract int getBitDepth();

    public abstract ImageFormat getImageType();

    public abstract String getImageTypeDescription();

    public abstract String getMIMEType();

    public abstract int getColorType();

    public abstract int getRGB(WhiteSpaceReader var1) throws IOException;

    public abstract int getRGB(InputStream var1) throws IOException;

    public void readImage(BufferedImage bi, InputStream is) throws IOException {
        DataBuffer buffer = bi.getRaster().getDataBuffer();
        if (!this.RAWBITS) {
            WhiteSpaceReader wsr = new WhiteSpaceReader(is);
            for (int y = 0; y < this.height; ++y) {
                for (int x = 0; x < this.width; ++x) {
                    int rgb = this.getRGB(wsr);
                    buffer.setElem(y * this.width + x, rgb);
                }
            }
        } else {
            for (int y = 0; y < this.height; ++y) {
                for (int x = 0; x < this.width; ++x) {
                    int rgb = this.getRGB(is);
                    buffer.setElem(y * this.width + x, rgb);
                }
            }
        }
    }

    public void dump() {
    }
}

