/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sanselan.formats.png;

import java.io.IOException;
import org.apache.sanselan.ImageReadException;

public class BitParser {
    private final byte[] bytes;
    private final int BitsPerPixel;
    private final int BitDepth;

    public BitParser(byte[] bytes, int BitsPerPixel, int BitDepth) {
        this.bytes = bytes;
        this.BitsPerPixel = BitsPerPixel;
        this.BitDepth = BitDepth;
    }

    public int getSample(int pixel_index_in_scanline, int SampleIndex) throws ImageReadException, IOException {
        int pixel_index_bits = this.BitsPerPixel * pixel_index_in_scanline;
        int sample_index_bits = pixel_index_bits + SampleIndex * this.BitDepth;
        int sample_index_bytes = sample_index_bits >> 3;
        if (this.BitDepth == 8) {
            return 0xFF & this.bytes[sample_index_bytes];
        }
        if (this.BitDepth < 8) {
            int b = 0xFF & this.bytes[sample_index_bytes];
            int bits_to_shift = 8 - ((pixel_index_bits & 7) + this.BitDepth);
            int bitmask = (1 << this.BitDepth) - 1;
            return (b >>= bits_to_shift) & bitmask;
        }
        if (this.BitDepth == 16) {
            return 0xFF & this.bytes[sample_index_bytes] << 8 | 0xFF & this.bytes[sample_index_bytes + 1];
        }
        throw new ImageReadException("PNG: bad BitDepth: " + this.BitDepth);
    }

    public int getSampleAsByte(int pixel_index_in_scanline, int SampleIndex) throws ImageReadException, IOException {
        int sample = this.getSample(pixel_index_in_scanline, SampleIndex);
        int rot = 8 - this.BitDepth;
        if (rot > 0) {
            sample <<= rot;
        } else if (rot < 0) {
            sample >>= -rot;
        }
        return 0xFF & sample;
    }
}

