package com.game.objects;

import org.anddev.andengine.engine.handler.physics.PhysicsHandler;
import org.anddev.andengine.entity.scene.Scene;
import org.anddev.andengine.entity.sprite.AnimatedSprite;
import org.anddev.andengine.entity.sprite.AnimatedSprite.IAnimationListener;
import org.anddev.andengine.opengl.texture.region.TiledTextureRegion;

import android.content.Context;

import com.game.commons.cTools;
import com.game.commons.cGame_Commons.ACTION_PLAYER;
import com.game.interfaces.IGame_CommonItem;

public class cGame_Object_Part extends AnimatedSprite implements IGame_CommonItem{
	
	protected int gop_id; 
	public String gop_tradecode;
	public PhysicsHandler oPhysicsHandler;
	
	public cGame_Object_Part(float pX, float pY, float pTileWidth,float pTileHeight, TiledTextureRegion pTiledTextureRegion,String tTRADECODE) {
		super(pX, pY, pTileWidth, pTileHeight, pTiledTextureRegion);
		this.gop_id=cTools.generic_id();
		this.gop_tradecode=tTRADECODE;
		
		   //**************** VELOCITAT INICIAL ***********************
	       oPhysicsHandler = new PhysicsHandler(this);
		   this.registerUpdateHandler(oPhysicsHandler);
		   this.oPhysicsHandler.setVelocity(0, 0);
		
	}
	
	@Override
	public void getInfo(Context tActivity)
	{
		
		//Toast.makeText(tActivity,"Cyborg -->" + this.id + " - " + p.name + " - " + this.TRADECODE,Toast.LENGTH_LONG).show();
	}
	
	@Override
	public void addScene(Scene ts)
	{
		ts.attachChild(this);
	}

	@Override
	public void move() 
	{
		float currX=this.getX()+1;
		float currY=this.getY()+1;
		this.setPosition(currX,currY);
	}

	@Override
	public void anima(long ms,ACTION_PLAYER action) {
		this.setScale(3.0f);
		
		switch(action)
		{
			case HIT_LEFT:
				this.animate(new long[] { ms,ms,ms,ms,ms,ms,ms,ms }, 10, 17,0, new IAnimationListener(){

					@Override
					public void onAnimationEnd(AnimatedSprite pAnimatedSprite) {
						pAnimatedSprite.setCurrentTileIndex(10);
						
					}});
				break; 
			case HIT_RIGHT:
				this.animate(new long[] { ms,ms,ms,ms,ms,ms,ms,ms,ms }, 28, 36,0, new IAnimationListener(){

					@Override
					public void onAnimationEnd(AnimatedSprite pAnimatedSprite) {
						pAnimatedSprite.setCurrentTileIndex(29);
						
					}});
				break;
				/*
			case HIT_FRONT:
				this.animate(new long[] { ms,ms,ms,ms,ms,ms }, 12, 17,0, new IAnimationListener(){

					@Override
					public void onAnimationEnd(AnimatedSprite pAnimatedSprite) {
						pAnimatedSprite.setCurrentTileIndex(12);
						
					}});
				humano.animate(new long[] { ms,ms,ms,ms,ms,ms }, 12, 17,0, new IAnimationListener(){

					@Override
					public void onAnimationEnd(AnimatedSprite pAnimatedSprite) {
						pAnimatedSprite.setCurrentTileIndex(12);
						
					}});
				break;
			case HIT_BACK:
				this.animate(new long[] { ms,ms,ms,ms,ms,ms }, 0, 5,0, new IAnimationListener(){

					@Override
					public void onAnimationEnd(AnimatedSprite pAnimatedSprite) {
						pAnimatedSprite.setCurrentTileIndex(0);
						
					}});
				humano.animate(new long[] { ms,ms,ms,ms,ms,ms }, 0, 5,0, new IAnimationListener(){

					@Override
					public void onAnimationEnd(AnimatedSprite pAnimatedSprite) {
						pAnimatedSprite.setCurrentTileIndex(0);
						
					}});
				break;*/
		}
		
		
	}
	
	
	
}
