/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sanselan.formats.jpeg.segments;

import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import org.apache.sanselan.ImageReadException;
import org.apache.sanselan.formats.jpeg.IptcElement;
import org.apache.sanselan.formats.jpeg.IptcType;
import org.apache.sanselan.formats.jpeg.JpegImageParser;
import org.apache.sanselan.formats.jpeg.segments.APPNSegment;

public class App13Segment
extends APPNSegment {
    protected final JpegImageParser parser;
    public final Vector elements = new Vector();

    public App13Segment(JpegImageParser parser, int marker, int marker_length, InputStream is2) throws ImageReadException, IOException {
        super(marker, marker_length, is2);
        this.parser = parser;
        boolean verbose = false;
        if (!this.compareByteArrays(this.bytes, 0, JpegImageParser.PhotoshopIdentificationString, 0, JpegImageParser.PhotoshopIdentificationString.length)) {
            throw new ImageReadException("Invalid App13 Segment");
        }
        int index = JpegImageParser.PhotoshopIdentificationString.length;
        block0: while (index < this.bytes.length) {
            if (!this.compareByteArrays(this.bytes, index, JpegImageParser.CONST_8BIM, 0, JpegImageParser.CONST_8BIM.length)) {
                throw new ImageReadException("Invalid .CONST_8BIM Segment");
            }
            int segmentType = this.convertByteArrayToShort("SegmentType", index += JpegImageParser.CONST_8BIM.length, this.bytes);
            if (verbose) {
                this.debugNumber("SegmentType", segmentType, 2);
            }
            index += 2;
            int segmentSize = this.convertByteArrayToShort("SegmentSize", index += 4, this.bytes);
            if (verbose) {
                this.debugNumber("fSegmentSize", segmentSize, 2);
            }
            int index2 = index += 2;
            index += segmentSize;
            if (segmentSize % 2 != 0) {
                ++index;
            }
            while (index2 < index) {
                int iptcPrefix = this.convertByteArrayToShort("IPTCPrefix", index2, this.bytes);
                if (verbose) {
                    this.debugNumber("fIPTCPrefix", iptcPrefix, 2);
                }
                index2 += 2;
                if (iptcPrefix != 7170) continue block0;
                byte iptcSegmentType = this.bytes[index2];
                int iptcSegmentSize = this.convertByteArrayToShort("IPTCSegmentSize", ++index2, this.bytes);
                byte[] iptcData = this.readBytearray("iptc_data", this.bytes, index2 += 2, iptcSegmentSize);
                index2 += iptcSegmentSize;
                String value = new String(iptcData);
                IptcType iptcType = IptcType.getIptcType(iptcSegmentType);
                IptcElement element = new IptcElement(iptcType, value);
                this.elements.add(element);
            }
        }
    }
}

