package com.game.objects;

import java.util.ArrayList;

import org.anddev.andengine.engine.handler.physics.PhysicsHandler;
import org.anddev.andengine.entity.scene.Scene;
import org.anddev.andengine.entity.sprite.AnimatedSprite;
import org.anddev.andengine.entity.sprite.AnimatedSprite.IAnimationListener;
import org.anddev.andengine.opengl.texture.region.TiledTextureRegion;

import android.content.Context;

import com.commons.game_commons;
import com.game.commons.cTools;
import com.game.commons.cGame_Commons.ACTION_PLAYER;
import com.game.interfaces.IGame_CommonItem;

public class cGame_Object extends AnimatedSprite implements IGame_CommonItem {
	
	private int go_id;
	public String go_name;
	private String go_barcode;
	public PhysicsHandler go_PhysicsHandler;
	// Coleccion de Partes del Objeto
	private ArrayList<cGame_Object_Part> go_Parts = new ArrayList<cGame_Object_Part>();
	private TiledTextureRegion go_TiledTextureRegion;
	
	public cGame_Object(float pX, float pY, float pTileWidth,float pTileHeight, TiledTextureRegion pTiledTextureRegion,String tname,String tBARCODE) {
		super(pX, pY, pTileWidth, pTileHeight, pTiledTextureRegion);
		this.go_id=cTools.generic_id();
		this.go_name=tname;
		this.go_barcode=tBARCODE;
	    //**************** VELOCITAT INICIAL ***********************
		go_PhysicsHandler = new PhysicsHandler(this);
	    this.registerUpdateHandler(go_PhysicsHandler);
	    this.go_PhysicsHandler.setVelocity(0, 0);
	    this.go_TiledTextureRegion=pTiledTextureRegion;
	}
	
	@Override
	public void getInfo(Context tActivity)
	{
		//Toast.makeText(tActivity,"Humano -->" + this.id + " - " + this.name + " - " + this.BARCODE,Toast.LENGTH_LONG).show();
	}

	public void addPart(cGame_Object_Part tPart)
	{
		go_Parts.add(tPart);
	}
	
	@Override
	public void addScene(Scene ts)
	{
		this.setScale(3.0f);
		// Add main object
		ts.attachChild(this);
		// Add all parts of the object
		for (cGame_Object_Part c_Part : go_Parts )
		{
			c_Part.setScale(3.0f);
			ts.attachChild(c_Part);
		}
	}
	
	public void move(float ctot) 
	{
		float x_offset = (float) (Math.cos(Math.toRadians(ctot+180)));
		float y_offset = (float) (Math.sin(Math.toRadians(ctot+180)));
		
		this.setRotation(ctot+180);		
		this.go_PhysicsHandler.setVelocity(500 * x_offset,500 * y_offset);

		// move all parts of the object
		for (cGame_Object_Part c_Part : go_Parts )
		{
			c_Part.setRotation(ctot+180);		
			c_Part.gop_PhysicsHandler.setVelocity(500 * x_offset,500 * y_offset);
		}
		
	}
	

	@Override
	public void anima(long ms,ACTION_PLAYER action) 
	{
			switch(action)
			{
				case HIT_LEFT:
					this.animate(new long[] { ms,ms,ms,ms,ms,ms,ms,ms }, 10, 17,0, new IAnimationListener(){
	
						@Override
						public void onAnimationEnd(AnimatedSprite pAnimatedSprite) {
							pAnimatedSprite.setCurrentTileIndex(10);
							
						}});
					break; 
				case HIT_RIGHT:
					this.animate(new long[] { ms,ms,ms,ms,ms,ms,ms,ms,ms }, 28, 36,0, new IAnimationListener(){
	
						@Override
						public void onAnimationEnd(AnimatedSprite pAnimatedSprite) {
							pAnimatedSprite.setCurrentTileIndex(29);
							
						}});
					break;
			}
			
			// move all parts of the object
			for (cGame_Object_Part c_Part : go_Parts )
			{

				c_Part.setScale(3.0f);
				
				switch(action)
				{
					case HIT_LEFT:
						c_Part.animate(new long[] { ms,ms,ms,ms,ms,ms,ms,ms }, 10, 17,0, new IAnimationListener(){

							@Override
							public void onAnimationEnd(AnimatedSprite pAnimatedSprite) {
								pAnimatedSprite.setCurrentTileIndex(10);
								
							}});
						break; 
					case HIT_RIGHT:
						c_Part.animate(new long[] { ms,ms,ms,ms,ms,ms,ms,ms,ms }, 28, 36,0, new IAnimationListener(){

							@Override
							public void onAnimationEnd(AnimatedSprite pAnimatedSprite) {
								pAnimatedSprite.setCurrentTileIndex(29);
								
							}});
						break;
				}	
			
			}
		
	}

	@Override
	public void move() {
		// TODO Auto-generated method stub
		
	}
	
}
