/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sanselan.common;

import java.io.IOException;
import java.io.InputStream;
import org.apache.sanselan.ImageReadException;
import org.apache.sanselan.common.BinaryFileFunctions;

public class BinaryFileParser
extends BinaryFileFunctions {
    private int byteOrder = 77;

    public BinaryFileParser(int byteOrder) {
        this.byteOrder = byteOrder;
    }

    public BinaryFileParser() {
    }

    protected void setByteOrder(int a, int b) throws ImageReadException, IOException {
        if (a != b) {
            throw new ImageReadException("Byte Order bytes don't match (" + a + ", " + b + ").");
        }
        if (a == 77) {
            this.byteOrder = a;
        } else if (a == 73) {
            this.byteOrder = a;
        } else {
            throw new ImageReadException("Unknown Byte Order hint: " + a);
        }
    }

    protected void setByteOrder(int byteOrder) {
        this.byteOrder = byteOrder;
    }

    protected int getByteOrder() {
        return this.byteOrder;
    }

    protected final int convertByteArrayToInt(String name, byte[] bytes) {
        return this.convertByteArrayToInt(name, bytes, this.byteOrder);
    }

    public final int convertByteArrayToShort(String name, byte[] bytes) {
        return this.convertByteArrayToShort(name, bytes, this.byteOrder);
    }

    public final int convertByteArrayToShort(String name, int start, byte[] bytes) {
        return this.convertByteArrayToShort(name, start, bytes, this.byteOrder);
    }

    public final int read4Bytes(String name, InputStream is, String exception) throws ImageReadException, IOException {
        return this.read4Bytes(name, is, exception, this.byteOrder);
    }

    public final int read3Bytes(String name, InputStream is, String exception) throws ImageReadException, IOException {
        return this.read3Bytes(name, is, exception, this.byteOrder);
    }

    public final int read2Bytes(String name, InputStream is, String exception) throws ImageReadException, IOException {
        return this.read2Bytes(name, is, exception, this.byteOrder);
    }
}

