/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads;

import android.content.Context;
import android.util.DisplayMetrics;
import android.util.TypedValue;

public class AdSize {
    public static final int FULL_WIDTH = -1;
    public static final int AUTO_HEIGHT = -2;
    public static final int LANDSCAPE_AD_HEIGHT = 32;
    public static final int PORTRAIT_AD_HEIGHT = 50;
    public static final int LARGE_AD_HEIGHT = 90;
    public static final AdSize SMART_BANNER = new AdSize(-1, -2, "mb");
    public static final AdSize BANNER = new AdSize(320, 50, "mb");
    public static final AdSize IAB_MRECT = new AdSize(300, 250, "as");
    public static final AdSize IAB_BANNER = new AdSize(468, 60, "as");
    public static final AdSize IAB_LEADERBOARD = new AdSize(728, 90, "as");
    public static final AdSize IAB_WIDE_SKYSCRAPER = new AdSize(160, 600, "as");
    private final int a;
    private final int b;
    private boolean c;
    private boolean d;
    private boolean e;
    private String f;

    public AdSize(int width, int height) {
        this(width, height, null);
        if (this.a()) {
            this.e = false;
            this.f = "mb";
        } else {
            this.e = true;
        }
    }

    private AdSize(int width, int height, String type) {
        this.a = width;
        this.b = height;
        this.f = type;
        this.c = width == -1;
        this.d = height == -2;
        this.e = false;
    }

    public static AdSize createAdSize(AdSize adSize, Context context) {
        if (context == null || !adSize.a()) {
            return adSize.a() ? BANNER : adSize;
        }
        int n2 = adSize.c ? AdSize.a(context) : adSize.getWidth();
        int n3 = adSize.d ? AdSize.b(context) : adSize.getHeight();
        AdSize adSize2 = new AdSize(n2, n3, adSize.f);
        adSize2.d = adSize.d;
        adSize2.c = adSize.c;
        adSize2.e = adSize.e;
        return adSize2;
    }

    public boolean equals(Object other) {
        if (!(other instanceof AdSize)) {
            return false;
        }
        AdSize adSize = (AdSize)other;
        return this.a == adSize.a && this.b == adSize.b;
    }

    public int hashCode() {
        return Integer.valueOf(this.a).hashCode() << 16 | Integer.valueOf(this.b).hashCode() & 0xFFFF;
    }

    public int getWidth() {
        if (this.a < 0) {
            throw new UnsupportedOperationException("Ad size was not set before getWidth() was called.");
        }
        return this.a;
    }

    public int getHeight() {
        if (this.b < 0) {
            throw new UnsupportedOperationException("Ad size was not set before getHeight() was called.");
        }
        return this.b;
    }

    private boolean a() {
        return this.a < 0 || this.b < 0;
    }

    public boolean isFullWidth() {
        return this.c;
    }

    public boolean isAutoHeight() {
        return this.d;
    }

    public boolean isCustomAdSize() {
        return this.e;
    }

    public String toString() {
        return this.getWidth() + "x" + this.getHeight() + (this.f == null ? "" : "_" + this.f);
    }

    public int getWidthInPixels(Context context) {
        return (int)TypedValue.applyDimension((int)1, (float)this.a, (DisplayMetrics)context.getResources().getDisplayMetrics());
    }

    public int getHeightInPixels(Context context) {
        return (int)TypedValue.applyDimension((int)1, (float)this.b, (DisplayMetrics)context.getResources().getDisplayMetrics());
    }

    public boolean isSizeAppropriate(int width, int height) {
        return (double)width <= (double)this.a * 1.25 && (double)width >= (double)this.a * 0.8 && (double)height <= (double)this.b * 1.25 && (double)height >= (double)this.b * 0.8;
    }

    public AdSize findBestSize(AdSize ... options) {
        AdSize adSize = null;
        double d2 = 0.0;
        if (options != null) {
            for (AdSize adSize2 : options) {
                if (!this.isSizeAppropriate(adSize2.a, adSize2.b)) continue;
                double d3 = (double)adSize2.a * (double)adSize2.b / ((double)this.a * (double)this.b);
                if (d3 > 1.0) {
                    d3 = 1.0 / d3;
                }
                if (!(d3 > d2)) continue;
                adSize = adSize2;
                d2 = d3;
            }
        }
        return adSize;
    }

    private static int a(Context context) {
        DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
        return (int)((float)displayMetrics.widthPixels / displayMetrics.density);
    }

    private static int b(Context context) {
        DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
        int n2 = (int)((float)displayMetrics.heightPixels / displayMetrics.density);
        if (n2 <= 400) {
            return 32;
        }
        if (n2 <= 720) {
            return 50;
        }
        return 90;
    }
}

