/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sanselan.formats.tiff;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import org.apache.sanselan.ImageReadException;
import org.apache.sanselan.common.byteSources.ByteSource;
import org.apache.sanselan.formats.tiff.TagInfo;
import org.apache.sanselan.formats.tiff.TiffConstants;
import org.apache.sanselan.formats.tiff.TiffElement;
import org.apache.sanselan.formats.tiff.fieldtypes.FieldType;

public class TiffField
implements TiffConstants {
    public final TagInfo tagInfo;
    public final FieldType fieldType;
    public final int tag;
    public final int type;
    public final int length;
    public final int valueOffset;
    public final byte[] valueOffsetBytes;
    public byte[] oversizeValue = null;
    public final int byteOrder;
    public static final String Attribute_Tag = "Tag";

    public TiffField(int tag, int type, int Length, int ValueOffset, byte[] ValueOffsetBytes, int byteOrder) {
        this.tag = tag;
        this.type = type;
        this.length = Length;
        this.valueOffset = ValueOffset;
        this.valueOffsetBytes = ValueOffsetBytes;
        this.byteOrder = byteOrder;
        this.fieldType = TiffField.getFieldType(type);
        this.tagInfo = TiffField.getTag(tag);
    }

    public TiffElement getOversizeValueElement() {
        if (this.fieldType.isLocalValue(this)) {
            return null;
        }
        return new OversizeValueElement(this.valueOffset, this.oversizeValue.length);
    }

    public void setOversizeValue(byte[] bytes) {
        this.oversizeValue = bytes;
    }

    private static FieldType getFieldType(int value) {
        for (int i = 0; i < FIELD_TYPES.length; ++i) {
            FieldType fieldType = FIELD_TYPES[i];
            if (fieldType.type != value) continue;
            return fieldType;
        }
        return FIELD_TYPE_UNKNOWN;
    }

    private static TagInfo getTag(int value) {
        for (int i = 0; i < TIFF_TAGS.length; ++i) {
            TagInfo fTag = TIFF_TAGS[i];
            if (fTag.tag != value) continue;
            return fTag;
        }
        return TIFF_TAG_Unknown;
    }

    private int getValueLengthInBytes() {
        int unit_length = this.fieldType.length;
        int ValueLength = unit_length * this.length;
        return ValueLength;
    }

    public void fillInValue(ByteSource byteSource) throws ImageReadException, IOException {
        if (this.fieldType.isLocalValue(this)) {
            return;
        }
        int ValueLength = this.getValueLengthInBytes();
        byte[] bytes = byteSource.getBlock(this.valueOffset, ValueLength);
        this.setOversizeValue(bytes);
    }

    public String getValueDescription() {
        return this.getValueDescription(this.getValue());
    }

    private String getValueDescription(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Number) {
            return o.toString();
        }
        if (o instanceof String) {
            return "'" + o.toString().trim() + "'";
        }
        if (o instanceof Date) {
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
            return df.format((Date)o);
        }
        if (o instanceof Object[]) {
            Object[] objects = (Object[])o;
            StringBuffer result = new StringBuffer();
            for (int i = 0; i < objects.length; ++i) {
                Object object = objects[i];
                if (i > 50) {
                    result.append("... (" + objects.length + ")");
                    break;
                }
                if (i > 0) {
                    result.append(", ");
                }
                result.append("" + object);
            }
            return result.toString();
        }
        if (o instanceof int[]) {
            int[] values = (int[])o;
            StringBuffer result = new StringBuffer();
            for (int i = 0; i < values.length; ++i) {
                int value = values[i];
                if (i > 50) {
                    result.append("... (" + values.length + ")");
                    break;
                }
                if (i > 0) {
                    result.append(", ");
                }
                result.append("" + value);
            }
            return result.toString();
        }
        if (o instanceof long[]) {
            long[] values = (long[])o;
            StringBuffer result = new StringBuffer();
            for (int i = 0; i < values.length; ++i) {
                long value = values[i];
                if (i > 50) {
                    result.append("... (" + values.length + ")");
                    break;
                }
                if (i > 0) {
                    result.append(", ");
                }
                result.append("" + value);
            }
            return result.toString();
        }
        if (o instanceof double[]) {
            double[] values = (double[])o;
            StringBuffer result = new StringBuffer();
            for (int i = 0; i < values.length; ++i) {
                double value = values[i];
                if (i > 50) {
                    result.append("... (" + values.length + ")");
                    break;
                }
                if (i > 0) {
                    result.append(", ");
                }
                result.append("" + value);
            }
            return result.toString();
        }
        if (o instanceof byte[]) {
            byte[] values = (byte[])o;
            StringBuffer result = new StringBuffer();
            for (int i = 0; i < values.length; ++i) {
                byte value = values[i];
                if (i > 50) {
                    result.append("... (" + values.length + ")");
                    break;
                }
                if (i > 0) {
                    result.append(", ");
                }
                result.append("" + value);
            }
            return result.toString();
        }
        if (o instanceof char[]) {
            char[] values = (char[])o;
            StringBuffer result = new StringBuffer();
            for (int i = 0; i < values.length; ++i) {
                char value = values[i];
                if (i > 50) {
                    result.append("... (" + values.length + ")");
                    break;
                }
                if (i > 0) {
                    result.append(", ");
                }
                result.append("" + value);
            }
            return result.toString();
        }
        if (o instanceof float[]) {
            float[] values = (float[])o;
            StringBuffer result = new StringBuffer();
            for (int i = 0; i < values.length; ++i) {
                float value = values[i];
                if (i > 50) {
                    result.append("... (" + values.length + ")");
                    break;
                }
                if (i > 0) {
                    result.append(", ");
                }
                result.append("" + value);
            }
            return result.toString();
        }
        return "Unknown: " + o.getClass().getName();
    }

    public void dump() {
        this.dump(new PrintWriter(new OutputStreamWriter(System.out)));
    }

    public void dump(PrintWriter pw) {
        this.dump(pw, null);
    }

    public void dump(PrintWriter pw, String prefix) {
        if (prefix != null) {
            pw.print(prefix + ": ");
        }
        pw.println(this.toString());
        pw.flush();
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append(this.tag + " (0x" + Integer.toHexString(this.tag) + ": " + this.tagInfo.name + "): ");
        result.append(this.getValueDescription(this.getValue()) + " (" + this.length + " " + this.fieldType.name + ")");
        return result.toString();
    }

    public String getTagName() {
        return this.tagInfo.name;
    }

    public String getFieldTypeName() {
        return this.fieldType.name;
    }

    public Object getValue() {
        return this.tagInfo.getValue(this);
    }

    public int[] getValueAsIntArray() {
        Object o = this.getValue();
        if (o == null) {
            return null;
        }
        if (o instanceof Number) {
            return new int[]{((Number)o).intValue()};
        }
        if (o instanceof Number[]) {
            Number[] numbers = (Number[])o;
            int[] result = new int[numbers.length];
            for (int i = 0; i < numbers.length; ++i) {
                result[i] = numbers[i].intValue();
            }
            return result;
        }
        if (o instanceof int[]) {
            int[] numbers = (int[])o;
            int[] result = new int[numbers.length];
            for (int i = 0; i < numbers.length; ++i) {
                result[i] = numbers[i];
            }
            return result;
        }
        return null;
    }

    static {
        Hashtable<String, TagInfo> map = new Hashtable<String, TagInfo>();
        for (int i = 0; i < TIFF_TAGS.length; ++i) {
            TagInfo tag = TIFF_TAGS[i];
            Object o = map.get("" + tag.tag);
            if (o == null) {
                map.put("" + tag.tag, tag);
                continue;
            }
            System.out.println("Duplicate tag: " + tag.tag);
            System.out.println("\tNew name: " + tag.name);
            System.out.println("\tOld name: " + ((TagInfo)o).name);
        }
    }

    public final class OversizeValueElement
    extends TiffElement {
        public OversizeValueElement(int offset, int length) {
            super(offset, length);
        }

        public String getElementDescription(boolean verbose) {
            if (verbose) {
                return null;
            }
            return "OversizeValueElement, tag: " + TiffField.this.tagInfo.name + ", fieldType: " + TiffField.this.fieldType.name;
        }
    }
}

