/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sanselan.formats.tiff.write;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import org.apache.sanselan.ImageWriteException;
import org.apache.sanselan.common.BinaryConstants;
import org.apache.sanselan.common.BinaryOutputStream;
import org.apache.sanselan.common.PackBits;
import org.apache.sanselan.common.mylzw.MyLZWCompressor;
import org.apache.sanselan.formats.tiff.RawTiffImageData;
import org.apache.sanselan.formats.tiff.TagInfo;
import org.apache.sanselan.formats.tiff.TiffConstants;
import org.apache.sanselan.formats.tiff.TiffDirectory;
import org.apache.sanselan.formats.tiff.write.WriteField;
import org.apache.sanselan.util.Debug;
import org.apache.sanselan.util.DebugOutputStream;

public class TiffImageWriter
implements TiffConstants,
BinaryConstants {
    public static final int DEFAULT_WRITE_BYTE_ORDER = 73;
    private final int byteOrder;

    public TiffImageWriter() {
        this.byteOrder = 73;
    }

    public TiffImageWriter(int byteOrder) {
        this.byteOrder = byteOrder;
    }

    public byte[][] getStrips(BufferedImage src, int fSamplesPerPixel, int bitsPerSample, int rowsPerStrip) {
        int width = src.getWidth();
        int height = src.getHeight();
        int stripCount = (height + rowsPerStrip - 1) / rowsPerStrip;
        Object result = null;
        result = new byte[stripCount][];
        int remaining_rows = height;
        for (int i = 0; i < stripCount; ++i) {
            int rowsInStrip = Math.min(rowsPerStrip, remaining_rows);
            remaining_rows -= rowsInStrip;
            int bitsInStrip = bitsPerSample * rowsInStrip * width * fSamplesPerPixel;
            int bytesInStrip = (bitsInStrip + 7) / 8;
            byte[] uncompressed = new byte[bytesInStrip];
            int counter = 0;
            int stop = i * rowsPerStrip + rowsPerStrip;
            for (int y = i * rowsPerStrip; y < height && y < stop; ++y) {
                for (int x = 0; x < width; ++x) {
                    int rgb = src.getRGB(x, y);
                    int red = 0xFF & rgb >> 16;
                    int green = 0xFF & rgb >> 8;
                    int blue = 0xFF & rgb >> 0;
                    uncompressed[counter++] = (byte)red;
                    uncompressed[counter++] = (byte)green;
                    uncompressed[counter++] = (byte)blue;
                }
            }
            result[i] = uncompressed;
        }
        return result;
    }

    public void writeImage(BufferedImage src, OutputStream os, Map params) throws ImageWriteException, IOException {
        int i;
        if ((params = new Hashtable(params)).containsKey("FORMAT")) {
            params.remove("FORMAT");
        }
        int width = src.getWidth();
        int height = src.getHeight();
        int photometricInterpretation = 2;
        int compression = 5;
        if (params.containsKey("COMPRESSION")) {
            Object value = params.get("COMPRESSION");
            if (value != null) {
                if (!(value instanceof Number)) {
                    throw new ImageWriteException("Invalid compression parameter: " + value);
                }
                compression = ((Number)value).intValue();
            }
            params.remove("COMPRESSION");
        }
        int samplesPerPixel = 3;
        int bitsPerSample = 8;
        int rowsPerStrip = 8000 / (width * 3);
        rowsPerStrip = Math.max(1, rowsPerStrip);
        byte[][] strips = this.getStrips(src, 3, 8, rowsPerStrip);
        if (params.size() > 0) {
            Object firstKey = params.keySet().iterator().next();
            throw new ImageWriteException("Unknown parameter: " + firstKey);
        }
        if (compression == 32773) {
            for (i = 0; i < strips.length; ++i) {
                strips[i] = new PackBits().compress(strips[i]);
            }
        } else if (compression == 5) {
            for (i = 0; i < strips.length; ++i) {
                byte[] uncompressed = strips[i];
                int LZWMinimumCodeSize = 8;
                MyLZWCompressor compressor = new MyLZWCompressor(LZWMinimumCodeSize, 77, true);
                byte[] compressed = compressor.compress(uncompressed);
                strips[i] = compressed;
            }
        } else if (compression != 1) {
            throw new ImageWriteException("Invalid compression parameter (Only LZW, Packbits and uncompressed supported).");
        }
        Directory directory = new Directory(1);
        WriteField field = new WriteField(TIFF_TAG_ImageWidth, FIELD_TYPE_LONG, 1, FIELD_TYPE_LONG.writeData(new int[]{width}, this.byteOrder));
        directory.add(field);
        field = new WriteField(TIFF_TAG_ImageLength, FIELD_TYPE_LONG, 1, FIELD_TYPE_LONG.writeData(new int[]{height}, this.byteOrder));
        directory.add(field);
        field = new WriteField(TIFF_TAG_PhotometricInterpretation, FIELD_TYPE_SHORT, 1, FIELD_TYPE_SHORT.writeData(new int[]{2}, this.byteOrder));
        directory.add(field);
        field = new WriteField(TIFF_TAG_Compression, FIELD_TYPE_SHORT, 1, FIELD_TYPE_SHORT.writeData(new int[]{compression}, this.byteOrder));
        directory.add(field);
        field = new WriteField(TIFF_TAG_SamplesPerPixel, FIELD_TYPE_SHORT, 1, FIELD_TYPE_SHORT.writeData(new int[]{3}, this.byteOrder));
        directory.add(field);
        field = new WriteField(TIFF_TAG_BitsPerSample, FIELD_TYPE_SHORT, 3, FIELD_TYPE_SHORT.writeData(new int[]{8, 8, 8}, this.byteOrder));
        directory.add(field);
        field = new WriteField(TIFF_TAG_RowsPerStrip, FIELD_TYPE_LONG, 1, FIELD_TYPE_LONG.writeData(new int[]{rowsPerStrip}, this.byteOrder));
        directory.add(field);
        int resolutionUnit = 2;
        WriteField field2 = new WriteField(TIFF_TAG_ResolutionUnit, FIELD_TYPE_SHORT, 1, FIELD_TYPE_SHORT.writeData(new int[]{resolutionUnit}, this.byteOrder));
        directory.add(field2);
        int xResolution = 72;
        field2 = new WriteField(TIFF_TAG_XResolution, FIELD_TYPE_RATIONAL, 1, FIELD_TYPE_RATIONAL.writeData(xResolution, 1, this.byteOrder));
        directory.add(field2);
        int yResolution = 72;
        field2 = new WriteField(TIFF_TAG_YResolution, FIELD_TYPE_RATIONAL, 1, FIELD_TYPE_RATIONAL.writeData(yResolution, 1, this.byteOrder));
        directory.add(field2);
        RawTiffImageData.Strips rawTiffImageData = new RawTiffImageData.Strips(strips);
        directory.setRawTiffImageData(rawTiffImageData);
        Vector<Directory> directories = new Vector<Directory>();
        directories.add(directory);
        this.writeDirectories(os, directories);
    }

    private void writeImageFileHeader(BinaryOutputStream bos) throws IOException, ImageWriteException {
        bos.write(this.byteOrder);
        bos.write(this.byteOrder);
        bos.write2Bytes(42);
        int foffsetToFirstIFD = 8;
        bos.write4Bytes(foffsetToFirstIFD);
    }

    private static int imageDataPaddingLength(int dataLength) {
        return (4 - dataLength % 4) % 4;
    }

    private Directory findDirectoryByType(Vector directories, int type) {
        for (int i = 0; i < directories.size(); ++i) {
            Directory directory = (Directory)directories.get(i);
            if (directory.type != type) continue;
            return directory;
        }
        return null;
    }

    public void writeDirectories(OutputStream os, Vector directories) throws IOException, ImageWriteException {
        PointerDirectoriesInfo pointerDirectoriesInfo = this.pointerDirectoriesStep(directories);
        this.calculateLengthsAndOffsetsStep(directories);
        this.updateDirectoryPointersStep(pointerDirectoriesInfo);
        DebugOutputStream dos = null;
        BinaryOutputStream bos = new BinaryOutputStream(os, this.byteOrder);
        this.writeStep(bos, directories, dos);
    }

    private PointerDirectoriesInfo pointerDirectoriesStep(Vector directories) throws ImageWriteException {
        Directory firstDirectory = (Directory)directories.get(0);
        WriteField exifDirectoryOffsetField = null;
        Directory exifDirectory = this.findDirectoryByType(directories, 4);
        if (null != exifDirectory && null == (exifDirectoryOffsetField = firstDirectory.findField(TIFF_TAG_Exif_IFD_Pointer))) {
            exifDirectoryOffsetField = new WriteField(TIFF_TAG_Exif_IFD_Pointer, FIELD_TYPE_LONG, 1, FIELD_TYPE_LONG.writeData(new int[]{0}, this.byteOrder));
            firstDirectory.add(exifDirectoryOffsetField);
        }
        WriteField gpsDirectoryOffsetField = null;
        Directory gpsDirectory = this.findDirectoryByType(directories, 6);
        if (null != gpsDirectory && null == (gpsDirectoryOffsetField = firstDirectory.findField(TIFF_TAG_GPSInfo_IFD_Pointer))) {
            gpsDirectoryOffsetField = new WriteField(TIFF_TAG_GPSInfo_IFD_Pointer, FIELD_TYPE_LONG, 1, FIELD_TYPE_LONG.writeData(new int[]{0}, this.byteOrder));
            firstDirectory.add(gpsDirectoryOffsetField);
        }
        WriteField iteroperabilityDirectoryOffsetField = null;
        Directory iteroperabilityDirectory = this.findDirectoryByType(directories, 7);
        if (null != iteroperabilityDirectory) {
            if (null == exifDirectory) {
                throw new ImageWriteException("Can't write iteroperability directory without EXIF directory.");
            }
            iteroperabilityDirectoryOffsetField = exifDirectory.findField(TIFF_TAG_Interoperability_IFD_Pointer);
            if (null == iteroperabilityDirectoryOffsetField) {
                iteroperabilityDirectoryOffsetField = new WriteField(TIFF_TAG_Interoperability_IFD_Pointer, FIELD_TYPE_LONG, 1, FIELD_TYPE_LONG.writeData(new int[]{0}, this.byteOrder));
                exifDirectory.add(iteroperabilityDirectoryOffsetField);
            }
        }
        return new PointerDirectoriesInfo(exifDirectoryOffsetField, exifDirectory, gpsDirectoryOffsetField, gpsDirectory, iteroperabilityDirectoryOffsetField, iteroperabilityDirectory);
    }

    private void calculateLengthsAndOffsetsStep(Vector directories) throws IOException, ImageWriteException {
        int offset = 8;
        Directory previousDirectory = null;
        for (int i = 0; i < directories.size(); ++i) {
            Directory directory = (Directory)directories.get(i);
            directory.sortFields();
            directory.offset = offset;
            if (directory.type == 4 || directory.type == 6 || directory.type == 7) {
                directory.calculateLengths(this.byteOrder);
                offset += directory.totalLength;
                continue;
            }
            if (null != previousDirectory) {
                previousDirectory.nextDirectoryOffset = offset;
            }
            directory.calculateLengths(this.byteOrder);
            offset += directory.totalLength;
            previousDirectory = directory;
        }
    }

    private void updateDirectoryPointersStep(PointerDirectoriesInfo pointerDirectoriesInfo) {
        byte[] value;
        if (null != pointerDirectoriesInfo.exifDirectory) {
            value = FIELD_TYPE_LONG.writeData(new int[]{pointerDirectoriesInfo.exifDirectory.offset}, this.byteOrder);
            pointerDirectoriesInfo.exifDirectoryOffsetField.setData(value);
        }
        if (null != pointerDirectoriesInfo.gpsDirectory) {
            value = FIELD_TYPE_LONG.writeData(new int[]{pointerDirectoriesInfo.gpsDirectory.offset}, this.byteOrder);
            pointerDirectoriesInfo.gpsDirectoryOffsetField.setData(value);
        }
        if (null != pointerDirectoriesInfo.iteroperabilityDirectory) {
            value = FIELD_TYPE_LONG.writeData(new int[]{pointerDirectoriesInfo.iteroperabilityDirectory.offset}, this.byteOrder);
            pointerDirectoriesInfo.iteroperabilityDirectoryOffsetField.setData(value);
        }
    }

    private void writeStep(BinaryOutputStream bos, Vector directories, DebugOutputStream dos) throws IOException, ImageWriteException {
        long count;
        this.writeImageFileHeader(bos);
        long lastCount = 0L;
        if (null != dos) {
            count = dos.count();
            Debug.debug("image header start: " + lastCount + ", end: " + dos.count() + ", length: " + (count - lastCount));
            lastCount = count;
        }
        for (int i = 0; i < directories.size(); ++i) {
            Directory directory = (Directory)directories.get(i);
            directory.write(bos);
            if (null == dos) continue;
            count = dos.count();
            Debug.debug("directory(" + TiffDirectory.description(directory.type) + ")" + " start: " + lastCount + ", end: " + dos.count() + ", length: " + (count - lastCount) + ", expected length: " + directory.totalLength);
            lastCount = count;
        }
    }

    private static class ImageDataInfo {
        public final byte[][] imageData;
        public final int[] imageDataOffsets;
        public final int[] imageDataByteCounts;
        public final WriteField imageDataOffsetsField;
        public final int totalLength;

        public ImageDataInfo(byte[][] imageData, int[] imageDataOffsets, int[] imageDataByteCounts, WriteField imageDataOffsetsField, int totalLength) {
            this.imageData = imageData;
            this.imageDataOffsets = imageDataOffsets;
            this.imageDataByteCounts = imageDataByteCounts;
            this.imageDataOffsetsField = imageDataOffsetsField;
            this.totalLength = totalLength;
        }
    }

    private static class PointerDirectoriesInfo {
        public final WriteField exifDirectoryOffsetField;
        public final Directory exifDirectory;
        public final WriteField gpsDirectoryOffsetField;
        public final Directory gpsDirectory;
        public final WriteField iteroperabilityDirectoryOffsetField;
        public final Directory iteroperabilityDirectory;

        public PointerDirectoriesInfo(WriteField exifDirectoryOffsetField, Directory exifDirectory, WriteField gpsDirectoryOffsetField, Directory gpsDirectory, WriteField iteroperabilityDirectoryOffsetField, Directory iteroperabilityDirectory) {
            this.exifDirectoryOffsetField = exifDirectoryOffsetField;
            this.exifDirectory = exifDirectory;
            this.gpsDirectoryOffsetField = gpsDirectoryOffsetField;
            this.gpsDirectory = gpsDirectory;
            this.iteroperabilityDirectoryOffsetField = iteroperabilityDirectoryOffsetField;
            this.iteroperabilityDirectory = iteroperabilityDirectory;
        }
    }

    public static final class Directory {
        public static final int UNDEFINED_VALUE = -1;
        public final int type;
        public int internalLength = -1;
        public int totalLength = -1;
        public int offset = -1;
        public int nextDirectoryOffset = -1;
        private final Vector fields = new Vector();
        private ImageDataInfo imageDataInfo = null;
        WriteField jpegImageDataOffsetField = null;
        private RawTiffImageData rawTiffImageData = null;
        private byte[] rawJpegImageData = null;

        public Directory(int type) {
            this.type = type;
        }

        public void add(WriteField field) {
            this.fields.add(field);
        }

        public Vector getFields() {
            return new Vector(this.fields);
        }

        public WriteField findField(TagInfo tagInfo) {
            for (int i = 0; i < this.fields.size(); ++i) {
                WriteField field = (WriteField)this.fields.get(i);
                if (field.tagInfo.tag != tagInfo.tag) continue;
                return field;
            }
            return null;
        }

        public void sortFields() {
            Comparator comparator = new Comparator(){

                public int compare(Object o1, Object o2) {
                    WriteField e1 = (WriteField)o1;
                    WriteField e2 = (WriteField)o2;
                    return e1.tagInfo.tag - e2.tagInfo.tag;
                }
            };
            Collections.sort(this.fields, comparator);
        }

        public void calculateLengths(int byteOrder) throws IOException, ImageWriteException {
            int imageDataOffset;
            this.tiffImageDataInfoStep(byteOrder);
            this.jpegImageDataInfoStep(byteOrder);
            this.totalLength = this.internalLength = 12 * this.fields.size() + 4 + 2;
            for (int i = 0; i < this.fields.size(); ++i) {
                WriteField field = (WriteField)this.fields.get(i);
                this.totalLength += field.getSeperateValueLength();
            }
            if (null != this.imageDataInfo) {
                imageDataOffset = this.offset + this.totalLength;
                this.totalLength += this.imageDataInfo.totalLength;
                this.updateTiffImageDataOffsetsStep(imageDataOffset, byteOrder);
            }
            if (null != this.rawJpegImageData) {
                imageDataOffset = this.offset + this.totalLength;
                this.totalLength += this.rawJpegImageData.length;
                this.totalLength += TiffImageWriter.imageDataPaddingLength(this.rawJpegImageData.length);
                this.updateJpegImageDataOffsetsStep(imageDataOffset, byteOrder);
            }
        }

        public String description() {
            return TiffDirectory.description(this.type);
        }

        public void write(BinaryOutputStream bos) throws IOException, ImageWriteException {
            WriteField field;
            int i;
            int nextSeperateValueOffset = this.offset + this.internalLength;
            bos.write2Bytes(this.fields.size());
            for (i = 0; i < this.fields.size(); ++i) {
                field = (WriteField)this.fields.get(i);
                nextSeperateValueOffset += field.writeDirectoryEntry(bos, nextSeperateValueOffset);
            }
            if (this.nextDirectoryOffset == -1) {
                bos.write4Bytes(0);
            } else {
                bos.write4Bytes(this.nextDirectoryOffset);
            }
            for (i = 0; i < this.fields.size(); ++i) {
                field = (WriteField)this.fields.get(i);
                field.writeSeperateValue(bos);
            }
            if (null != this.rawTiffImageData) {
                byte[][] imageData = this.rawTiffImageData.getRawImageData();
                for (int i2 = 0; i2 < imageData.length; ++i2) {
                    bos.writeByteArray(imageData[i2]);
                    int imageDataByteCount = imageData[i2].length;
                    int remainder = TiffImageWriter.imageDataPaddingLength(imageDataByteCount);
                    for (int j = 0; j < remainder; ++j) {
                        bos.write(0);
                    }
                }
            }
            if (null != this.rawJpegImageData) {
                bos.writeByteArray(this.rawJpegImageData);
                int remainder = TiffImageWriter.imageDataPaddingLength(this.rawJpegImageData.length);
                for (int j = 0; j < remainder; ++j) {
                    bos.write(0);
                }
            }
        }

        private void tiffImageDataInfoStep(int byteOrder) {
            if (null == this.rawTiffImageData) {
                return;
            }
            byte[][] imageData = this.rawTiffImageData.getRawImageData();
            boolean stripsNotTiles = this.rawTiffImageData.stripsNotTiles();
            int[] imageDataOffsets = null;
            int[] imageDataByteCounts = null;
            WriteField imageDataOffsetsField = null;
            imageDataOffsets = new int[imageData.length];
            imageDataByteCounts = new int[imageData.length];
            int totalLength = 0;
            for (int i = 0; i < imageData.length; ++i) {
                imageDataByteCounts[i] = imageData[i].length;
                totalLength += imageData[i].length;
                totalLength += TiffImageWriter.imageDataPaddingLength(imageData[i].length);
            }
            TagInfo tagInfo = stripsNotTiles ? TiffConstants.TIFF_TAG_StripOffsets : TiffConstants.TIFF_TAG_TileOffsets;
            imageDataOffsetsField = this.findField(tagInfo);
            if (null == imageDataOffsetsField) {
                imageDataOffsetsField = new WriteField(tagInfo, TiffConstants.FIELD_TYPE_LONG, imageDataOffsets.length, TiffConstants.FIELD_TYPE_LONG.writeData(imageDataOffsets, byteOrder));
                this.add(imageDataOffsetsField);
            }
            tagInfo = stripsNotTiles ? TiffConstants.TIFF_TAG_StripByteCounts : TiffConstants.TIFF_TAG_TileByteCounts;
            byte[] data = TiffConstants.FIELD_TYPE_LONG.writeData(imageDataByteCounts, byteOrder);
            WriteField field = this.findField(tagInfo);
            if (null == field) {
                this.add(new WriteField(tagInfo, TiffConstants.FIELD_TYPE_LONG, imageDataByteCounts.length, data));
            } else {
                field.setData(data);
            }
            this.imageDataInfo = new ImageDataInfo(imageData, imageDataOffsets, imageDataByteCounts, imageDataOffsetsField, totalLength);
        }

        private void jpegImageDataInfoStep(int byteOrder) {
            if (null == this.rawJpegImageData) {
                return;
            }
            TagInfo tagInfo = TiffConstants.TIFF_TAG_JPEGInterchangeFormat;
            this.jpegImageDataOffsetField = this.findField(tagInfo);
            if (null == this.jpegImageDataOffsetField) {
                this.jpegImageDataOffsetField = new WriteField(tagInfo, TiffConstants.FIELD_TYPE_LONG, 1, TiffConstants.FIELD_TYPE_LONG.writeData(new int[]{0}, byteOrder));
                this.add(this.jpegImageDataOffsetField);
            }
            tagInfo = TiffConstants.TIFF_TAG_JPEGInterchangeFormatLength;
            byte[] data = TiffConstants.FIELD_TYPE_LONG.writeData(new int[]{this.rawJpegImageData.length}, byteOrder);
            WriteField field = this.findField(tagInfo);
            if (null == field) {
                this.add(new WriteField(tagInfo, TiffConstants.FIELD_TYPE_LONG, 1, data));
            } else {
                field.setData(data);
            }
        }

        private void updateTiffImageDataOffsetsStep(int imageDataOffset, int byteOrder) throws IOException, ImageWriteException {
            int currentOffset = imageDataOffset;
            for (int i = 0; i < this.imageDataInfo.imageData.length; ++i) {
                this.imageDataInfo.imageDataOffsets[i] = currentOffset;
                currentOffset += this.imageDataInfo.imageDataByteCounts[i];
                currentOffset += TiffImageWriter.imageDataPaddingLength(this.imageDataInfo.imageDataByteCounts[i]);
            }
            this.imageDataInfo.imageDataOffsetsField.setData(TiffConstants.FIELD_TYPE_LONG.writeData(this.imageDataInfo.imageDataOffsets, byteOrder));
        }

        private void updateJpegImageDataOffsetsStep(int imageDataOffset, int byteOrder) throws IOException, ImageWriteException {
            this.jpegImageDataOffsetField.setData(TiffConstants.FIELD_TYPE_LONG.writeData(new int[]{imageDataOffset}, byteOrder));
        }

        public void setRawTiffImageData(RawTiffImageData rawTiffImageData) {
            this.rawTiffImageData = rawTiffImageData;
        }

        public RawTiffImageData getRawTiffImageData() {
            return this.rawTiffImageData;
        }

        public void setRawJpegImageData(byte[] rawJpegImageData) {
            this.rawJpegImageData = rawJpegImageData;
        }

        public byte[] getRawJpegImageData() {
            return this.rawJpegImageData;
        }
    }
}

