/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sanselan.sampleUsage;

import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import org.apache.sanselan.ImageReadException;
import org.apache.sanselan.Sanselan;
import org.apache.sanselan.common.IBufferedImageFactory;

public class ImageReadExample {
    public static BufferedImage imageReadExample(File file) throws ImageReadException, IOException {
        HashMap<String, ManagedImageBufferedImageFactory> params = new HashMap<String, ManagedImageBufferedImageFactory>();
        params.put("BUFFERED_IMAGE_FACTORY", new ManagedImageBufferedImageFactory());
        BufferedImage image = Sanselan.getBufferedImage(file, params);
        return image;
    }

    public static class ManagedImageBufferedImageFactory
    implements IBufferedImageFactory {
        public BufferedImage getColorBufferedImage(int width, int height, boolean hasAlpha) {
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            GraphicsDevice gd = ge.getDefaultScreenDevice();
            GraphicsConfiguration gc = gd.getDefaultConfiguration();
            return gc.createCompatibleImage(width, height, 3);
        }

        public BufferedImage getGrayscaleBufferedImage(int width, int height, boolean hasAlpha) {
            return this.getColorBufferedImage(width, height, hasAlpha);
        }
    }
}

