/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sanselan.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.sanselan.SanselanConstants;
import org.apache.sanselan.util.Debug;

public class IOUtils
implements SanselanConstants {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getInputStreamBytes(InputStream is) throws IOException {
        ByteArrayOutputStream os = null;
        try {
            int count;
            os = new ByteArrayOutputStream(4096);
            is = new BufferedInputStream(is);
            byte[] buffer = new byte[4096];
            while ((count = is.read(buffer, 0, 4096)) > 0) {
                os.write(buffer, 0, count);
            }
            os.flush();
            byte[] byArray = os.toByteArray();
            return byArray;
        }
        finally {
            try {
                if (os != null) {
                    os.close();
                }
            }
            catch (IOException e) {
                Debug.debug(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getFileBytes(File file) throws IOException {
        FileInputStream is = null;
        try {
            is = new FileInputStream(file);
            byte[] byArray = IOUtils.getInputStreamBytes(is);
            return byArray;
        }
        finally {
            try {
                if (is != null) {
                    ((InputStream)is).close();
                }
            }
            catch (IOException e) {
                Debug.debug(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeToFile(byte[] src, File file) throws IOException {
        ByteArrayInputStream stream = null;
        try {
            stream = new ByteArrayInputStream(src);
            IOUtils.putInputStreamToFile(stream, file);
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (Exception e) {
                Debug.debug(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void putInputStreamToFile(InputStream src, File file) throws IOException {
        FileOutputStream stream = null;
        try {
            if (file.getParentFile() != null) {
                file.getParentFile().mkdirs();
            }
            stream = new FileOutputStream(file);
            IOUtils.copyStreamToStream(src, stream);
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (Exception e) {
                Debug.debug(e);
            }
        }
    }

    public static void copyStreamToStream(InputStream src, OutputStream dst) throws IOException {
        IOUtils.copyStreamToStream(src, dst, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyStreamToStream(InputStream src, OutputStream dst, boolean close_streams) throws IOException {
        BufferedInputStream bis = null;
        BufferedOutputStream bos = null;
        try {
            int count;
            bis = new BufferedInputStream(src);
            bos = new BufferedOutputStream(dst);
            byte[] buffer = new byte[4096];
            while ((count = bis.read(buffer, 0, buffer.length)) > 0) {
                dst.write(buffer, 0, count);
            }
            bos.flush();
        }
        finally {
            if (close_streams) {
                try {
                    if (bis != null) {
                        bis.close();
                    }
                }
                catch (IOException e) {
                    Debug.debug(e);
                }
                try {
                    if (bos != null) {
                        bos.close();
                    }
                }
                catch (IOException e) {
                    Debug.debug(e);
                }
            }
        }
    }
}

