/*
 * Decompiled with CFR 0.152.
 */
package com.google.analytics.tracking.android;

import android.content.Context;
import com.google.analytics.tracking.android.AdHitIdGenerator;
import com.google.analytics.tracking.android.Analytics;
import com.google.analytics.tracking.android.AnalyticsThread;
import com.google.analytics.tracking.android.GAThread;
import com.google.analytics.tracking.android.GAUsage;
import com.google.analytics.tracking.android.GoogleTracker;
import com.google.analytics.tracking.android.Log;
import com.google.analytics.tracking.android.Tracker;
import com.google.analytics.tracking.android.TrackerHandler;
import com.google.analytics.tracking.android.Utils;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class GoogleAnalytics
implements Analytics,
TrackerHandler {
    private boolean debug;
    private AnalyticsThread thread;
    private Context context;
    private Tracker defaultTracker;
    private AdHitIdGenerator adHitIdGenerator;
    private volatile String clientId;
    private volatile Boolean appOptOut;
    private final Map<String, Tracker> trackers = new HashMap<String, Tracker>();
    private String lastTrackingId;
    private static GoogleAnalytics instance;

    private GoogleAnalytics() {
    }

    private GoogleAnalytics(Context context) {
        this(context, GAThread.getInstance(context));
    }

    private GoogleAnalytics(Context context, AnalyticsThread thread) {
        if (context == null) {
            throw new IllegalArgumentException("context cannot be null");
        }
        this.context = context.getApplicationContext();
        this.thread = thread;
        this.adHitIdGenerator = new AdHitIdGenerator();
        this.thread.requestAppOptOut(new Analytics.AppOptOutCallback(){

            @Override
            public void reportAppOptOut(boolean optOut) {
                GoogleAnalytics.this.appOptOut = optOut;
            }
        });
        this.thread.requestClientId(new AnalyticsThread.ClientIdCallback(){

            @Override
            public void reportClientId(String clientId) {
                GoogleAnalytics.this.clientId = clientId;
            }
        });
    }

    public static synchronized GoogleAnalytics getInstance(Context context) {
        if (instance == null) {
            instance = new GoogleAnalytics(context);
        }
        return instance;
    }

    static synchronized GoogleAnalytics getInstance() {
        return instance;
    }

    static synchronized GoogleAnalytics getNewInstance(Context context, AnalyticsThread thread) {
        if (instance != null) {
            instance.close();
        }
        instance = new GoogleAnalytics(context, thread);
        return instance;
    }

    static synchronized void clearInstance() {
        instance = null;
    }

    @Override
    public void setDebug(boolean debug) {
        GAUsage.getInstance().setUsage(GAUsage.Field.SET_DEBUG);
        this.debug = debug;
        Log.setDebug(debug);
    }

    @Override
    public boolean debugEnabled() {
        GAUsage.getInstance().setUsage(GAUsage.Field.GET_DEBUG);
        return this.debug;
    }

    @Override
    public synchronized Tracker getTracker(String trackingId) {
        if (trackingId == null) {
            throw new IllegalArgumentException("trackingId cannot be null");
        }
        Tracker tracker = this.trackers.get(trackingId);
        if (tracker == null) {
            tracker = new GoogleTracker(trackingId, this);
            this.trackers.put(trackingId, tracker);
            if (this.defaultTracker == null) {
                this.defaultTracker = tracker;
            }
        }
        GAUsage.getInstance().setUsage(GAUsage.Field.GET_TRACKER);
        return tracker;
    }

    @Override
    public synchronized Tracker getDefaultTracker() {
        GAUsage.getInstance().setUsage(GAUsage.Field.GET_DEFAULT_TRACKER);
        return this.defaultTracker;
    }

    @Override
    public synchronized void setDefaultTracker(Tracker tracker) {
        GAUsage.getInstance().setUsage(GAUsage.Field.SET_DEFAULT_TRACKER);
        this.defaultTracker = tracker;
    }

    @Override
    public synchronized void closeTracker(Tracker tracker) {
        this.trackers.values().remove(tracker);
        if (tracker == this.defaultTracker) {
            this.defaultTracker = null;
        }
    }

    @Override
    public synchronized void sendHit(Map<String, String> hit) {
        if (hit == null) {
            throw new IllegalArgumentException("hit cannot be null");
        }
        hit.put("language", Utils.getLanguage(Locale.getDefault()));
        hit.put("adSenseAdMobHitId", Integer.toString(this.adHitIdGenerator.getAdHitId()));
        hit.put("screenResolution", this.context.getResources().getDisplayMetrics().widthPixels + "x" + this.context.getResources().getDisplayMetrics().heightPixels);
        hit.put("usage", GAUsage.getInstance().getAndClearSequence());
        GAUsage.getInstance().getAndClearUsage();
        this.thread.sendHit(hit);
        this.lastTrackingId = hit.get("trackingId");
    }

    void close() {
    }

    String getTrackingIdForAds() {
        return this.lastTrackingId;
    }

    String getClientIdForAds() {
        if (this.clientId == null) {
            return null;
        }
        return this.clientId.toString();
    }

    @Override
    public void setAppOptOut(boolean optOut) {
        GAUsage.getInstance().setUsage(GAUsage.Field.SET_APP_OPT_OUT);
        this.appOptOut = optOut;
        this.thread.setAppOptOut(optOut);
    }

    Boolean getAppOptOut() {
        return this.appOptOut;
    }

    @Override
    public void requestAppOptOut(Analytics.AppOptOutCallback callback) {
        GAUsage.getInstance().setUsage(GAUsage.Field.REQUEST_APP_OPT_OUT);
        if (this.appOptOut != null) {
            callback.reportAppOptOut(this.appOptOut);
        } else {
            this.thread.requestAppOptOut(callback);
        }
    }
}

