/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sanselan.formats.jpeg.exifRewrite;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.Vector;
import org.apache.sanselan.ImageReadException;
import org.apache.sanselan.ImageWriteException;
import org.apache.sanselan.common.BinaryFileParser;
import org.apache.sanselan.common.byteSources.ByteSource;
import org.apache.sanselan.formats.jpeg.JpegConstants;
import org.apache.sanselan.formats.jpeg.JpegImageParser;
import org.apache.sanselan.formats.jpeg.segments.GenericSegment;
import org.apache.sanselan.formats.jpeg.segments.UnknownSegment;
import org.apache.sanselan.formats.tiff.TagInfo;
import org.apache.sanselan.formats.tiff.TiffField;
import org.apache.sanselan.formats.tiff.TiffImageMetadata;
import org.apache.sanselan.formats.tiff.TiffImageParser;
import org.apache.sanselan.formats.tiff.fieldtypes.FieldType;
import org.apache.sanselan.formats.tiff.write.TiffImageWriter;
import org.apache.sanselan.formats.tiff.write.WriteField;
import org.apache.sanselan.util.Debug;

public class ExifRewriter
extends BinaryFileParser
implements JpegConstants {
    public ExifRewriter() {
        this.setByteOrder(77);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rewriteEXIFMetadata(ByteSource byteSource, OutputStream os, Map params) throws ImageReadException, IOException, ImageWriteException {
        Vector<Object> pieces = new Vector<Object>();
        InputStream is = null;
        UnknownSegment exifSegment = null;
        try {
            is = byteSource.getInputStream();
            this.readAndVerifyBytes(is, SOI, "Not a Valid JPEG File: doesn't begin with 0xffd8");
            int byteOrder = this.getByteOrder();
            int markerCount = 0;
            while (true) {
                byte[] markerBytes;
                int marker;
                if ((marker = this.convertByteArrayToShort("marker", markerBytes = this.readByteArray("markerBytes", 2, is, "markerBytes"), byteOrder)) == 65497 || marker == 65498) {
                    pieces.add(markerBytes);
                    pieces.add(this.getStreamBytes(is));
                    break;
                }
                byte[] markerLengthBytes = this.readByteArray("markerLengthBytes", 2, is, "markerLengthBytes");
                int markerLength = this.convertByteArrayToShort("markerLength", markerLengthBytes, byteOrder);
                UnknownSegment segment = new UnknownSegment(marker, markerLength - 2, is);
                if (marker != 65505) {
                    pieces.add(markerBytes);
                    pieces.add(markerLengthBytes);
                    pieces.add(segment.bytes);
                } else if (!JpegImageParser.isExifAPP1Segment(segment)) {
                    pieces.add(markerBytes);
                    pieces.add(markerLengthBytes);
                    pieces.add(segment.bytes);
                } else {
                    if (exifSegment != null) {
                        throw new ImageWriteException("More than one APP1 EXIF segment.");
                    }
                    exifSegment = segment;
                    pieces.add(segment);
                }
                ++markerCount;
            }
        }
        finally {
            try {
                is.close();
            }
            catch (Exception e) {
                Debug.debug(e);
            }
        }
        if (exifSegment == null) {
            throw new ImageWriteException("No APP1 EXIF segment found.");
        }
        byte[] exifBytes = exifSegment.bytes;
        exifBytes = this.getBytearrayTail("trimmed exif bytes", exifBytes, 6);
        TiffImageMetadata exifMetadata = (TiffImageMetadata)new TiffImageParser().getMetadata(exifBytes, params);
        byte[] newBytes = this.rewriteExif(exifMetadata, true);
        this.writeSegments(os, pieces, newBytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeSegments(OutputStream os, Vector segments, byte[] newBytes) throws ImageWriteException, IOException {
        int byteOrder = this.getByteOrder();
        try {
            os.write(SOI);
            for (int i = 0; i < segments.size(); ++i) {
                Object o = segments.get(i);
                if (o instanceof byte[]) {
                    byte[] bytes = (byte[])o;
                    os.write(bytes);
                    continue;
                }
                if (o instanceof GenericSegment) {
                    byte[] markerBytes = this.convertShortToByteArray(65505, byteOrder);
                    os.write(markerBytes);
                    int markerLength = newBytes.length + 2;
                    byte[] markerLengthBytes = this.convertShortToByteArray(markerLength, byteOrder);
                    os.write(markerLengthBytes);
                    os.write(newBytes);
                    continue;
                }
                throw new ImageWriteException("Unknown data: " + o);
            }
        }
        finally {
            try {
                os.close();
            }
            catch (Exception e) {
                Debug.debug(e);
            }
        }
    }

    public byte[] rewriteExif(TiffImageMetadata exif, boolean includeEXIFPrefix) throws IOException, ImageWriteException {
        if (exif == null) {
            return null;
        }
        int byteOrder = exif.contents.header.byteOrder;
        Vector<TiffImageWriter.Directory> dstDirs = new Vector<TiffImageWriter.Directory>();
        Vector srcDirs = exif.getDirectories();
        for (int i = 0; i < srcDirs.size(); ++i) {
            TiffImageMetadata.Directory srcDir = (TiffImageMetadata.Directory)srcDirs.get(i);
            TiffImageWriter.Directory dstDir = this.translate(srcDir, byteOrder);
            dstDirs.add(dstDir);
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        if (includeEXIFPrefix) {
            os.write(ExifIdentifierCode);
            os.write(0);
            os.write(0);
        }
        new TiffImageWriter(byteOrder).writeDirectories(os, dstDirs);
        return os.toByteArray();
    }

    private TiffImageWriter.Directory translate(TiffImageMetadata.Directory srcDir, int byteOrder) throws ImageWriteException {
        TiffImageWriter.Directory dstDir = new TiffImageWriter.Directory(srcDir.type);
        Vector entries = srcDir.getItems();
        for (int i = 0; i < entries.size(); ++i) {
            TiffImageMetadata.Item item = (TiffImageMetadata.Item)entries.get(i);
            TiffField srcField = item.getTiffField();
            TagInfo tag = srcField.tagInfo;
            FieldType tagtype = srcField.fieldType;
            int count = srcField.length;
            byte[] bytes = srcField.fieldType.getRawBytes(srcField);
            Object value = srcField.getValue();
            byte[] bytes2 = tag.isDate ? tagtype.getRawBytes(srcField) : tagtype.writeData(value, byteOrder);
            WriteField dstField = new WriteField(tag, tagtype, count, bytes2);
            dstDir.add(dstField);
        }
        dstDir.setRawTiffImageData(srcDir.getRawTiffImageData());
        dstDir.setRawJpegImageData(srcDir.getRawJpegImageData());
        return dstDir;
    }
}

