/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sanselan.palette;

import java.awt.image.BufferedImage;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import org.apache.sanselan.ImageWriteException;
import org.apache.sanselan.palette.Palette;
import org.apache.sanselan.palette.SimplePalette;
import org.apache.sanselan.util.Debug;

public class MedianCutQuantizer {
    private final boolean ignoreAlpha;
    private static final int ALPHA = 0;
    private static final int RED = 1;
    private static final int GREEN = 2;
    private static final int BLUE = 3;

    public MedianCutQuantizer(boolean ignore_alpha) {
        this.ignoreAlpha = ignore_alpha;
    }

    public Map groupColors1(BufferedImage image, int max, int mask) throws ImageWriteException {
        Hashtable<Integer, ColorCount> color_map = new Hashtable<Integer, ColorCount>();
        int width = image.getWidth();
        int height = image.getHeight();
        int[] row = new int[width];
        for (int y = 0; y < height; ++y) {
            image.getRGB(0, y, width, 1, row, 0, width);
            for (int x = 0; x < width; ++x) {
                ColorCount color;
                int argb = row[x];
                if (this.ignoreAlpha) {
                    argb &= 0xFFFFFF;
                }
                if ((color = (ColorCount)color_map.get(new Integer(argb &= mask))) == null) {
                    color = new ColorCount(argb);
                    color_map.put(new Integer(argb), color);
                    if (color_map.keySet().size() > max) {
                        return null;
                    }
                }
                ++color.count;
            }
        }
        return color_map;
    }

    public Map groupColors(BufferedImage image, int max_colors) throws ImageWriteException {
        int max = Integer.MAX_VALUE;
        for (int i = 0; i < 8; ++i) {
            int mask = 0xFF & 255 << i;
            mask = mask | mask << 8 | mask << 16 | mask << 24;
            Debug.debug("mask(" + i + ")", mask + " (" + Integer.toHexString(mask) + ")");
            Map result = this.groupColors1(image, max, mask);
            if (result == null) continue;
            return result;
        }
        throw new Error("");
    }

    public Palette process(BufferedImage image, int max_colors, boolean verbose) throws ImageWriteException {
        Map color_map = this.groupColors(image, max_colors);
        int discrete_colors = color_map.keySet().size();
        if (discrete_colors <= max_colors) {
            if (verbose) {
                Debug.debug("lossless palette: " + discrete_colors);
            }
            int[] palette = new int[discrete_colors];
            Vector color_counts = new Vector(color_map.values());
            for (int i = 0; i < color_counts.size(); ++i) {
                ColorCount color_count = (ColorCount)color_counts.get(i);
                palette[i] = color_count.argb;
                if (!this.ignoreAlpha) continue;
                int n = i;
                palette[n] = palette[n] | 0xFF000000;
            }
            return new SimplePalette(palette);
        }
        if (verbose) {
            Debug.debug("discrete colors: " + discrete_colors);
        }
        Vector<ColorGroup> color_groups = new Vector<ColorGroup>();
        ColorGroup root = new ColorGroup(new Vector(color_map.values()));
        color_groups.add(root);
        Comparator comparator = new Comparator(){

            public int compare(Object o1, Object o2) {
                ColorGroup cg1 = (ColorGroup)o1;
                ColorGroup cg2 = (ColorGroup)o2;
                if (cg1.max_diff == cg2.max_diff) {
                    return cg2.diff_total - cg1.diff_total;
                }
                return cg2.max_diff - cg1.max_diff;
            }
        };
        while (color_groups.size() < max_colors) {
            Collections.sort(color_groups, comparator);
            ColorGroup color_group = (ColorGroup)color_groups.get(0);
            if (color_group.max_diff == 0) break;
            if (!this.ignoreAlpha && color_group.alpha_diff > color_group.red_diff && color_group.alpha_diff > color_group.green_diff && color_group.alpha_diff > color_group.blue_diff) {
                this.doCut(color_group, 0, color_groups);
                continue;
            }
            if (color_group.red_diff > color_group.green_diff && color_group.red_diff > color_group.blue_diff) {
                this.doCut(color_group, 1, color_groups);
                continue;
            }
            if (color_group.green_diff > color_group.blue_diff) {
                this.doCut(color_group, 2, color_groups);
                continue;
            }
            this.doCut(color_group, 3, color_groups);
        }
        int palette_size = color_groups.size();
        if (verbose) {
            Debug.debug("palette size: " + palette_size);
        }
        int[] palette = new int[palette_size];
        int i = 0;
        while (i < color_groups.size()) {
            ColorGroup color_group = (ColorGroup)color_groups.get(i);
            palette[i] = color_group.getMedianValue();
            color_group.palette_index = i++;
            if (color_group.color_counts.size() >= 1) continue;
            throw new ImageWriteException("empty color_group: " + color_group);
        }
        if (palette_size > discrete_colors) {
            throw new ImageWriteException("palette_size>discrete_colors");
        }
        return new MedianCutPalette(root, palette);
    }

    private void doCut(ColorGroup color_group, final int mode, Vector color_groups) throws ImageWriteException {
        int limit;
        int median_index;
        int count_total = 0;
        for (int i = 0; i < color_group.color_counts.size(); ++i) {
            ColorCount color_count = (ColorCount)color_group.color_counts.get(i);
            count_total += color_count.count;
        }
        Comparator comparator = new Comparator(){

            public int compare(Object o1, Object o2) {
                ColorCount c1 = (ColorCount)o1;
                ColorCount c2 = (ColorCount)o2;
                switch (mode) {
                    case 0: {
                        return c1.alpha - c2.alpha;
                    }
                    case 1: {
                        return c1.red - c2.red;
                    }
                    case 2: {
                        return c1.green - c2.green;
                    }
                    case 3: {
                        return c1.blue - c2.blue;
                    }
                }
                return 0;
            }
        };
        Collections.sort(color_group.color_counts, comparator);
        int count_half = (int)Math.round((double)count_total / 2.0);
        int old_count = 0;
        int new_count = 0;
        for (median_index = 0; median_index < color_group.color_counts.size(); ++median_index) {
            ColorCount color_count = (ColorCount)color_group.color_counts.get(median_index);
            if ((new_count += color_count.count) >= count_half) break;
            old_count = new_count;
        }
        if (median_index == color_group.color_counts.size() - 1) {
            --median_index;
        } else if (median_index > 0) {
            int new_diff = Math.abs(new_count - count_half);
            int old_diff = Math.abs(count_half - old_count);
            if (old_diff < new_diff) {
                --median_index;
            }
        }
        color_groups.remove(color_group);
        Vector color_counts1 = new Vector(color_group.color_counts.subList(0, median_index + 1));
        Vector color_counts2 = new Vector(color_group.color_counts.subList(median_index + 1, color_group.color_counts.size()));
        ColorGroup less = new ColorGroup(new Vector(color_counts1));
        color_groups.add(less);
        ColorGroup more = new ColorGroup(new Vector(color_counts2));
        color_groups.add(more);
        ColorCount median_value = (ColorCount)color_group.color_counts.get(median_index);
        switch (mode) {
            case 0: {
                limit = median_value.alpha;
                break;
            }
            case 1: {
                limit = median_value.red;
                break;
            }
            case 2: {
                limit = median_value.green;
                break;
            }
            case 3: {
                limit = median_value.blue;
                break;
            }
            default: {
                throw new Error("Bad mode.");
            }
        }
        color_group.cut = new ColorGroupCut(less, more, mode, limit);
    }

    public class MedianCutPalette
    extends SimplePalette {
        private final ColorGroup root;

        public MedianCutPalette(ColorGroup root, int[] palette) {
            super(palette);
            this.root = root;
        }

        public int getPaletteIndex(int rgb) {
            ColorGroup cg = this.root;
            while (cg.cut != null) {
                ColorGroup next;
                cg = next = cg.cut.getColorGroup(rgb);
            }
            return cg.palette_index;
        }
    }

    private class ColorGroupCut {
        public final ColorGroup less;
        public final ColorGroup more;
        public final int mode;
        public final int limit;

        public ColorGroupCut(ColorGroup less, ColorGroup more, int mode, int limit) {
            this.less = less;
            this.more = more;
            this.mode = mode;
            this.limit = limit;
        }

        public ColorGroup getColorGroup(int argb) {
            int value;
            switch (this.mode) {
                case 0: {
                    value = 0xFF & argb >> 24;
                    break;
                }
                case 1: {
                    value = 0xFF & argb >> 16;
                    break;
                }
                case 2: {
                    value = 0xFF & argb >> 8;
                    break;
                }
                case 3: {
                    value = 0xFF & argb >> 0;
                    break;
                }
                default: {
                    throw new Error("bad mode.");
                }
            }
            if (value <= this.limit) {
                return this.less;
            }
            return this.more;
        }
    }

    private class ColorGroup {
        public ColorGroupCut cut = null;
        public int palette_index = -1;
        public final Vector color_counts;
        public int min_red = Integer.MAX_VALUE;
        public int max_red = Integer.MIN_VALUE;
        public int min_green = Integer.MAX_VALUE;
        public int max_green = Integer.MIN_VALUE;
        public int min_blue = Integer.MAX_VALUE;
        public int max_blue = Integer.MIN_VALUE;
        public int min_alpha = Integer.MAX_VALUE;
        public int max_alpha = Integer.MIN_VALUE;
        public final int alpha_diff;
        public final int red_diff;
        public final int green_diff;
        public final int blue_diff;
        public final int max_diff;
        public final int diff_total;

        public ColorGroup(Vector color_counts) throws ImageWriteException {
            this.color_counts = color_counts;
            if (color_counts.size() < 1) {
                throw new ImageWriteException("empty color_group");
            }
            for (int i = 0; i < color_counts.size(); ++i) {
                ColorCount color = (ColorCount)color_counts.get(i);
                this.min_alpha = Math.min(this.min_alpha, color.alpha);
                this.max_alpha = Math.max(this.max_alpha, color.alpha);
                this.min_red = Math.min(this.min_red, color.red);
                this.max_red = Math.max(this.max_red, color.red);
                this.min_green = Math.min(this.min_green, color.green);
                this.max_green = Math.max(this.max_green, color.green);
                this.min_blue = Math.min(this.min_blue, color.blue);
                this.max_blue = Math.max(this.max_blue, color.blue);
            }
            this.alpha_diff = this.max_alpha - this.min_alpha;
            this.red_diff = this.max_red - this.min_red;
            this.green_diff = this.max_green - this.min_green;
            this.blue_diff = this.max_blue - this.min_blue;
            this.max_diff = Math.max(MedianCutQuantizer.this.ignoreAlpha ? this.red_diff : Math.max(this.alpha_diff, this.red_diff), Math.max(this.green_diff, this.blue_diff));
            this.diff_total = (MedianCutQuantizer.this.ignoreAlpha ? 0 : this.alpha_diff) + this.red_diff + this.green_diff + this.blue_diff;
        }

        public boolean contains(int argb) {
            int alpha = 0xFF & argb >> 24;
            int red = 0xFF & argb >> 16;
            int green = 0xFF & argb >> 8;
            int blue = 0xFF & argb >> 0;
            if (!(MedianCutQuantizer.this.ignoreAlpha || alpha >= this.min_alpha && alpha <= this.max_alpha)) {
                return false;
            }
            if (red < this.min_red || red > this.max_red) {
                return false;
            }
            if (green < this.min_green || green > this.max_green) {
                return false;
            }
            return blue >= this.min_blue && blue <= this.max_blue;
        }

        public int getMedianValue() {
            long count_total = 0L;
            long alpha_total = 0L;
            long red_total = 0L;
            long green_total = 0L;
            long blue_total = 0L;
            for (int i = 0; i < this.color_counts.size(); ++i) {
                ColorCount color = (ColorCount)this.color_counts.get(i);
                count_total += (long)color.count;
                alpha_total += (long)(color.count * color.alpha);
                red_total += (long)(color.count * color.red);
                green_total += (long)(color.count * color.green);
                blue_total += (long)(color.count * color.blue);
            }
            int alpha = MedianCutQuantizer.this.ignoreAlpha ? 255 : (int)Math.round((double)alpha_total / (double)count_total);
            int red = (int)Math.round((double)red_total / (double)count_total);
            int green = (int)Math.round((double)green_total / (double)count_total);
            int blue = (int)Math.round((double)blue_total / (double)count_total);
            return alpha << 24 | red << 16 | green << 8 | blue;
        }

        public String toString() {
            return "{ColorGroup. min_red: " + Integer.toHexString(this.min_red) + ", max_red: " + Integer.toHexString(this.max_red) + ", min_green: " + Integer.toHexString(this.min_green) + ", max_green: " + Integer.toHexString(this.max_green) + ", min_blue: " + Integer.toHexString(this.min_blue) + ", max_blue: " + Integer.toHexString(this.max_blue) + ", min_alpha: " + Integer.toHexString(this.min_alpha) + ", max_alpha: " + Integer.toHexString(this.max_alpha) + ", max_diff: " + Integer.toHexString(this.max_diff) + ", diff_total: " + this.diff_total + "}";
        }
    }

    private static class ColorCount {
        public final int argb;
        public int count = 0;
        public final int alpha;
        public final int red;
        public final int green;
        public final int blue;

        public ColorCount(int argb) {
            this.argb = argb;
            this.alpha = 0xFF & argb >> 24;
            this.red = 0xFF & argb >> 16;
            this.green = 0xFF & argb >> 8;
            this.blue = 0xFF & argb >> 0;
        }

        public int hashCode() {
            return this.argb;
        }

        public boolean equals(Object o) {
            ColorCount other = (ColorCount)o;
            return other.argb == this.argb;
        }
    }
}

