/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sanselan.formats.tiff;

import java.awt.image.BufferedImage;
import java.util.Vector;
import org.apache.sanselan.common.IImageMetadata;
import org.apache.sanselan.common.ImageMetadata;
import org.apache.sanselan.formats.tiff.RawTiffImageData;
import org.apache.sanselan.formats.tiff.TiffContents;
import org.apache.sanselan.formats.tiff.TiffDirectory;
import org.apache.sanselan.formats.tiff.TiffField;

public class TiffImageMetadata
extends ImageMetadata {
    public final TiffContents contents;

    public TiffImageMetadata(TiffContents contents) {
        this.contents = contents;
    }

    public Vector getDirectories() {
        return super.getItems();
    }

    public Vector getItems() {
        Vector result = new Vector();
        Vector items = super.getItems();
        for (int i = 0; i < items.size(); ++i) {
            Directory dir = (Directory)items.get(i);
            result.addAll(dir.getItems());
        }
        return result;
    }

    public static class Item
    extends ImageMetadata.Item {
        private final TiffField entry;

        public Item(TiffField entry) {
            super(entry.getTagName(), entry.getValueDescription());
            this.entry = entry;
        }

        public TiffField getTiffField() {
            return this.entry;
        }
    }

    public static class Directory
    extends ImageMetadata
    implements IImageMetadata.IImageMetadataItem {
        private BufferedImage thumbnail = null;
        public final int type;
        private final TiffDirectory directory;
        private RawTiffImageData rawTiffImageData = null;
        private byte[] rawJpegImageData = null;

        public Directory(TiffDirectory directory) {
            this.type = directory.type;
            this.directory = directory;
        }

        public void add(TiffField entry) {
            this.add(new Item(entry));
        }

        public void setThumbnail(BufferedImage thumbnail) {
            this.thumbnail = thumbnail;
        }

        public BufferedImage getThumbnail() {
            return this.thumbnail;
        }

        public void setRawTiffImageData(RawTiffImageData rawImageData) {
            this.rawTiffImageData = rawImageData;
        }

        public RawTiffImageData getRawTiffImageData() {
            return this.rawTiffImageData;
        }

        public void setRawJpegImageData(byte[] bytes) {
            this.rawJpegImageData = bytes;
        }

        public byte[] getRawJpegImageData() {
            return this.rawJpegImageData;
        }

        public String toString(String prefix) {
            return (prefix != null ? prefix : "") + this.directory.description() + ": " + (this.rawTiffImageData != null ? " (rawImageData)" : "") + "\n" + super.toString(prefix) + "\n";
        }
    }
}

