/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sanselan.formats.bmp.writers;

import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.apache.sanselan.common.BinaryOutputStream;
import org.apache.sanselan.formats.bmp.writers.BMPWriter;
import org.apache.sanselan.palette.SimplePalette;

public class BMPWriterPalette
extends BMPWriter {
    private final SimplePalette palette;
    private final int bits_per_sample;

    public BMPWriterPalette(SimplePalette palette) {
        this.palette = palette;
        this.bits_per_sample = palette.length() <= 2 ? 1 : (palette.length() <= 16 ? 4 : 8);
        System.out.println("bits_per_sample: " + this.bits_per_sample);
    }

    public int getPaletteSize() {
        return this.palette.length();
    }

    public int getBitsPerPixel() {
        return this.bits_per_sample;
    }

    public void writePalette(BinaryOutputStream bos) throws IOException {
        for (int i = 0; i < this.palette.length(); ++i) {
            int rgb = this.palette.getEntry(i);
            int red = 0xFF & rgb >> 16;
            int green = 0xFF & rgb >> 8;
            int blue = 0xFF & rgb >> 0;
            bos.write(blue);
            bos.write(green);
            bos.write(red);
            bos.write(0);
        }
    }

    public byte[] getImageData(BufferedImage src) {
        int width = src.getWidth();
        int height = src.getHeight();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int bit_cache = 0;
        int bits_in_cache = 0;
        int bytecount = 0;
        for (int y = height - 1; y >= 0; --y) {
            for (int x = 0; x < width; ++x) {
                int argb = src.getRGB(x, y);
                int rgb = 0xFFFFFF & argb;
                int index = this.palette.getPaletteIndex(rgb);
                if (this.bits_per_sample == 8) {
                    baos.write(0xFF & index);
                    ++bytecount;
                    continue;
                }
                bit_cache = bit_cache << this.bits_per_sample | index;
                if ((bits_in_cache += this.bits_per_sample) < 8) continue;
                baos.write(0xFF & bit_cache);
                ++bytecount;
                bit_cache = 0;
                bits_in_cache = 0;
            }
            while (bytecount % 4 != 0) {
                baos.write(0);
                ++bytecount;
            }
        }
        return baos.toByteArray();
    }
}

