/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sanselan.formats.tiff.datareaders;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.apache.sanselan.ImageReadException;
import org.apache.sanselan.common.BitInputStream;
import org.apache.sanselan.common.byteSources.ByteSource;
import org.apache.sanselan.formats.tiff.datareaders.DataReader;
import org.apache.sanselan.formats.tiff.photometricinterpreters.PhotometricInterpreter;

public class DataReaderTiled
extends DataReader {
    private final int tileWidth;
    private final int tileLength;
    private final int[] tileOffsets;
    private final int[] tileByteCounts;
    private final int bitsPerPixel;
    private final int width;
    private final int height;
    private final int compression;

    public DataReaderTiled(PhotometricInterpreter fPhotometricInterpreter, int[] fTileOffsets, int[] fTileByteCounts, int TileWidth, int TileLength, int fBitsPerPixel, int[] fBitsPerSample, int Predictor, int fSamplesPerPixel, int width, int height, int fCompression, int byteOrder) {
        super(fPhotometricInterpreter, fBitsPerSample, Predictor, fSamplesPerPixel, byteOrder);
        this.tileOffsets = fTileOffsets;
        this.tileByteCounts = fTileByteCounts;
        this.tileWidth = TileWidth;
        this.tileLength = TileLength;
        this.bitsPerPixel = fBitsPerPixel;
        this.width = width;
        this.height = height;
        this.compression = fCompression;
    }

    private void interpretTile(BufferedImage bi, byte[] bytes, int start_x, int start_y) throws ImageReadException, IOException {
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        BitInputStream bis = new BitInputStream(bais);
        int pixels_per_tile = this.tileWidth * this.tileLength;
        int tile_x = 0;
        int tile_y = 0;
        for (int i = 0; i < pixels_per_tile; ++i) {
            int x = tile_x + start_x;
            int y = tile_y + start_y;
            int[] samples = this.getSamplesAsBytes(bis);
            if (x < this.width && y < this.height) {
                samples = this.applyPredictor(samples, x);
                this.photometricInterpreter.interpretPixel(bi, samples, x, y);
            }
            if (++tile_x < this.tileWidth) continue;
            tile_x = 0;
            bis.flushCache();
            if (++tile_y >= this.tileLength) break;
        }
    }

    public void readImageData(BufferedImage bi, ByteSource byteSource) throws ImageReadException, IOException {
        int bits_per_row = this.tileWidth * this.bitsPerPixel;
        int bytes_per_row = (bits_per_row + 7) / 8;
        int bytes_per_tile = bytes_per_row * this.tileLength;
        int x = 0;
        int y = 0;
        for (int tile = 0; tile < this.tileOffsets.length; ++tile) {
            int fTileOffset = this.tileOffsets[tile];
            int fTileByteCount = this.tileByteCounts[tile];
            byte[] compressed = byteSource.getBlock(fTileOffset, fTileByteCount);
            byte[] decompressed = this.decompress(compressed, this.compression, bytes_per_tile);
            this.interpretTile(bi, decompressed, x, y);
            if ((x += this.tileWidth) < this.width) continue;
            x = 0;
            if ((y += this.tileLength) >= this.height) break;
        }
    }
}

