package com.threadControl;

import java.util.ArrayList;
import java.util.Timer;
import java.util.TimerTask;

import com.pavan.dynamiclistview.R;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.os.Bundle;
import android.os.Handler;
import android.util.Log;
import android.view.View;
import android.widget.EditText;
import android.widget.ListView;
import android.widget.Toast;

public class MainActivity extends Activity {

	ListView lv;

	ArrayList<Model> modelList;
	CustomAdapter adapter;

	Timer Global_t = new Timer();   
	
	@Override
	protected void onCreate(Bundle savedInstanceState) {

		super.onCreate(savedInstanceState);
		setContentView(R.layout.activity_main);

		lv = (ListView) findViewById(R.id.lv);

		modelList = new ArrayList<Model>();
		adapter = new CustomAdapter(getApplicationContext(), modelList);
		lv.setAdapter(adapter);
		  
		TimerTask Global_task = new TimerTask() 
		{  
		    @Override  
		   public void run() 
		    {  
			    runOnUiThread(new Runnable() 
			    {  
				      @Override  
				      public void run() 
				      {
				    	  adapter.notifyDataSetChanged();
				      }
			      
			    });  
		    }  
		 };
		 Global_t.scheduleAtFixedRate(Global_task,500, 500); // initial delay 1 second, interval 1 second
		
	}

	public void addbtn(View v) {
		    // Creamos thread i passamos instancia al Model 
		Timer t = new Timer();
		TimerTask task = new TimerTask() 
		{  
		   int count=0;
		    @Override  
		   public void run() 
		    {  
			    runOnUiThread(new Runnable() 
			    {  
				      @Override  
				      public void run() 
				      {
				    	  count++;
				    	  if(count>9) count=0;
				    	  
				    	  Log.d("Thread num","Thread val:"+count);
				      }
			      
			    });  
		    }  
		 };
		 t.scheduleAtFixedRate(task, 1000, 1000); // initial delay 1 second, interval 1 second
		 
		Model md = new Model("Thread Loaded...",t);
		modelList.add(md);
		adapter.notifyDataSetChanged();
	
	}


	
	
	
}
