/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sanselan.common.mylzw;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.sanselan.common.mylzw.MyBitInputStream;

public final class MyLZWDecompressor {
    private static final int MAX_TABLE_SIZE = 4096;
    private final byte[][] table;
    private int codeSize;
    private final int initialCodeSize;
    private int codes = -1;
    private final int byteOrder;
    private final int clearCode;
    private final int eoiCode;
    private int written = 0;
    private boolean tiffLZWMode = false;

    public MyLZWDecompressor(int initialCodeSize, int byteOrder) {
        this.byteOrder = byteOrder;
        this.initialCodeSize = initialCodeSize;
        this.table = new byte[4096][];
        this.clearCode = 1 << initialCodeSize;
        this.eoiCode = this.clearCode + 1;
        this.InitializeTable();
    }

    private final void InitializeTable() {
        this.codeSize = this.initialCodeSize;
        int intial_entries_count = 1 << this.codeSize + 2;
        for (int i = 0; i < intial_entries_count; ++i) {
            this.table[i] = new byte[]{(byte)i};
        }
    }

    private final void clearTable() {
        this.codes = (1 << this.initialCodeSize) + 2;
        this.codeSize = this.initialCodeSize;
        this.incrementCodeSize();
    }

    private final int getNextCode(MyBitInputStream is) throws IOException {
        int result = is.readBits(this.codeSize);
        return result;
    }

    private final byte[] stringFromCode(int code) throws IOException {
        if (code >= this.codes || code < 0) {
            throw new IOException("Bad Code: " + code + " codes: " + this.codes + " code_size: " + this.codeSize + ", table: " + this.table.length);
        }
        return this.table[code];
    }

    private final boolean isInTable(int Code) {
        return Code < this.codes;
    }

    private final byte firstChar(byte[] bytes) {
        return bytes[0];
    }

    private final void addStringToTable(byte[] bytes) throws IOException {
        if (this.codes < 1 << this.codeSize) {
            this.table[this.codes] = bytes;
            ++this.codes;
        } else {
            throw new IOException("AddStringToTable: codes: " + this.codes + " code_size: " + this.codeSize);
        }
        this.checkCodeSize();
    }

    private final byte[] appendBytes(byte[] bytes, byte b) {
        byte[] result = new byte[bytes.length + 1];
        System.arraycopy(bytes, 0, result, 0, bytes.length);
        result[result.length - 1] = b;
        return result;
    }

    private final void writeToResult(OutputStream os, byte[] bytes) throws IOException {
        os.write(bytes);
        this.written += bytes.length;
    }

    public void setTiffLZWMode() {
        this.tiffLZWMode = true;
    }

    public byte[] decompress(InputStream is, int expected_length) throws IOException {
        int code;
        int oldCode = -1;
        MyBitInputStream mbis = new MyBitInputStream(is, this.byteOrder);
        if (this.tiffLZWMode) {
            mbis.setTiffLZWMode();
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream(expected_length);
        this.clearTable();
        while ((code = this.getNextCode(mbis)) != this.eoiCode) {
            if (code == this.clearCode) {
                this.clearTable();
                if (this.written >= expected_length || (code = this.getNextCode(mbis)) == this.eoiCode) break;
                this.writeToResult(baos, this.stringFromCode(code));
                oldCode = code;
            } else if (this.isInTable(code)) {
                this.writeToResult(baos, this.stringFromCode(code));
                this.addStringToTable(this.appendBytes(this.stringFromCode(oldCode), this.firstChar(this.stringFromCode(code))));
                oldCode = code;
            } else {
                byte[] OutString = this.appendBytes(this.stringFromCode(oldCode), this.firstChar(this.stringFromCode(oldCode)));
                this.writeToResult(baos, OutString);
                this.addStringToTable(OutString);
                oldCode = code;
            }
            if (this.written < expected_length) continue;
        }
        byte[] result = baos.toByteArray();
        return result;
    }

    private final void checkCodeSize() {
        int limit = 1 << this.codeSize;
        if (this.tiffLZWMode) {
            --limit;
        }
        if (this.codes == limit) {
            this.incrementCodeSize();
        }
    }

    private final void incrementCodeSize() {
        if (this.codeSize != 12) {
            ++this.codeSize;
        }
    }
}

