/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sanselan.formats.jpeg;

import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.text.NumberFormat;
import java.util.Collections;
import java.util.Map;
import java.util.Vector;
import org.apache.sanselan.ImageFormat;
import org.apache.sanselan.ImageInfo;
import org.apache.sanselan.ImageParser;
import org.apache.sanselan.ImageReadException;
import org.apache.sanselan.common.IImageMetadata;
import org.apache.sanselan.common.byteSources.ByteSource;
import org.apache.sanselan.formats.jpeg.IptcElement;
import org.apache.sanselan.formats.jpeg.JpegConstants;
import org.apache.sanselan.formats.jpeg.JpegImageMetadata;
import org.apache.sanselan.formats.jpeg.segments.App13Segment;
import org.apache.sanselan.formats.jpeg.segments.App2Segment;
import org.apache.sanselan.formats.jpeg.segments.GenericSegment;
import org.apache.sanselan.formats.jpeg.segments.JFIFSegment;
import org.apache.sanselan.formats.jpeg.segments.SOFNSegment;
import org.apache.sanselan.formats.jpeg.segments.Segment;
import org.apache.sanselan.formats.jpeg.segments.UnknownSegment;
import org.apache.sanselan.formats.tiff.TiffField;
import org.apache.sanselan.formats.tiff.TiffImageMetadata;
import org.apache.sanselan.formats.tiff.TiffImageParser;
import org.apache.sanselan.util.Debug;

public class JpegImageParser
extends ImageParser
implements JpegConstants {
    private static final String DEFAULT_EXTENSION = ".jpg";
    public static final String[] AcceptedExtensions = new String[]{".jpg", ".jpeg"};
    public static final boolean permissive = true;

    public JpegImageParser() {
        this.setByteOrder(77);
    }

    protected ImageFormat[] getAcceptedTypes() {
        return new ImageFormat[]{ImageFormat.IMAGE_FORMAT_JPEG};
    }

    public String getName() {
        return "Jpeg-Custom";
    }

    public String getDefaultExtension() {
        return DEFAULT_EXTENSION;
    }

    protected String[] getAcceptedExtensions() {
        return AcceptedExtensions;
    }

    public final BufferedImage getBufferedImage(ByteSource byteSource, Map params) throws ImageReadException, IOException {
        throw new ImageReadException("Sanselan cannot read or write JPEG images.");
    }

    private boolean keepMarker(int marker, int[] markers) {
        if (markers == null) {
            return true;
        }
        for (int i = 0; i < markers.length; ++i) {
            if (markers[i] != marker) continue;
            return true;
        }
        return false;
    }

    private Vector readMarkers(InputStream is, int[] markers, boolean return_after_first, boolean readEverything) throws ImageReadException, IOException {
        int marker;
        Vector<Segment> result = new Vector<Segment>();
        int markerCount = 0;
        while ((marker = this.read2Bytes("marker", is, "Not a Valid JPEG File")) != 65497) {
            int markerLength = this.read2Bytes("markerLength", is, "Not a Valid JPEG File");
            if (this.keepMarker(marker, markers)) {
                if (marker == 65517) {
                    result.add(new App13Segment(this, marker, markerLength - 2, is));
                } else if (marker == 65506) {
                    result.add(new App2Segment(marker, markerLength - 2, is));
                } else if (marker == 65504) {
                    result.add(new JFIFSegment(marker, markerLength - 2, is));
                } else if (marker >= 65472 && marker <= 65487) {
                    result.add(new SOFNSegment(marker, markerLength - 2, is));
                } else if (marker >= 65505 && marker <= 65519) {
                    result.add(new UnknownSegment(marker, markerLength - 2, is));
                } else {
                    if (marker == 65498) {
                        result.add(new UnknownSegment(marker, markerLength - 2, is));
                        return result;
                    }
                    this.skipBytes(is, markerLength - 2, "Not a Valid JPEG File: missing marker data");
                }
                if (this.debug) {
                    System.out.println("XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX");
                    System.out.println("XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX");
                    System.out.println("XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX");
                    System.out.println("XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX");
                }
                if (return_after_first) {
                    return result;
                }
            } else {
                this.skipBytes(is, markerLength - 2, "Not a Valid JPEG File: missing marker data");
            }
            if (marker == 65498) {
                return result;
            }
            if (this.debug) {
                System.out.println("");
            }
            ++markerCount;
        }
        return result;
    }

    private byte[] assembleSegments(Vector v) throws ImageReadException, IOException {
        try {
            return this.assembleSegments(v, false);
        }
        catch (ImageReadException e) {
            return this.assembleSegments(v, true);
        }
    }

    private byte[] assembleSegments(Vector v, boolean start_with_zero) throws ImageReadException, IOException {
        if (v.size() < 1) {
            throw new ImageReadException("No App2 Segments Found.");
        }
        int markerCount = ((App2Segment)v.get((int)0)).num_markers;
        if (v.size() != markerCount) {
            throw new ImageReadException("App2 Segments Missing.  Found: " + v.size() + ", Expected: " + markerCount + ".");
        }
        Collections.sort(v);
        int offset = start_with_zero ? 0 : 1;
        int total = 0;
        for (int i = 0; i < v.size(); ++i) {
            App2Segment segment = (App2Segment)v.get(i);
            if (i + offset != segment.cur_marker) {
                this.dumpSegments(v);
                throw new ImageReadException("Incoherent App2 Segment Ordering.  i: " + i + ", segment[" + i + "].cur_marker: " + segment.cur_marker + ".");
            }
            if (markerCount != segment.num_markers) {
                this.dumpSegments(v);
                throw new ImageReadException("Inconsistent App2 Segment Count info.  markerCount: " + markerCount + ", segment[" + i + "].num_markers: " + segment.num_markers + ".");
            }
            total += segment.icc_bytes.length;
        }
        byte[] result = new byte[total];
        int progress = 0;
        for (int i = 0; i < v.size(); ++i) {
            App2Segment segment = (App2Segment)v.get(i);
            System.arraycopy(segment.icc_bytes, 0, result, progress, segment.icc_bytes.length);
            progress += segment.icc_bytes.length;
        }
        return result;
    }

    private void dumpSegments(Vector v) {
        Debug.debug();
        Debug.debug("dumpSegments", v.size());
        for (int i = 0; i < v.size(); ++i) {
            App2Segment segment = (App2Segment)v.get(i);
            Debug.debug(i + ": " + segment.cur_marker + " / " + segment.num_markers);
        }
        Debug.debug();
    }

    public Vector readSegments(ByteSource byteSource, int[] markers, boolean return_after_first) throws ImageReadException, IOException {
        return this.readSegments(byteSource, markers, return_after_first, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector readSegments(ByteSource byteSource, int[] markers, boolean return_after_first, boolean readEverything) throws ImageReadException, IOException {
        InputStream is = null;
        try {
            is = byteSource.getInputStream();
            this.readAndVerifyBytes(is, SOI, "Not a Valid JPEG File: doesn't begin with 0xffd8");
            Vector vector = this.readMarkers(is, markers, return_after_first, readEverything);
            return vector;
        }
        finally {
            try {
                is.close();
            }
            catch (Exception e) {
                Debug.debug(e);
            }
        }
    }

    public byte[] getICCProfileBytes(ByteSource byteSource) throws ImageReadException, IOException {
        Vector<App2Segment> segments = this.readSegments(byteSource, new int[]{65506}, false);
        if (segments != null) {
            Vector<App2Segment> filtered = new Vector<App2Segment>();
            for (int i = 0; i < segments.size(); ++i) {
                App2Segment segment = (App2Segment)segments.get(i);
                if (segment.icc_bytes == null) continue;
                filtered.add(segment);
            }
            segments = filtered;
        }
        if (segments == null || segments.size() < 1) {
            return null;
        }
        byte[] bytes = this.assembleSegments(segments);
        if (this.debug) {
            System.out.println("bytes: " + (bytes == null ? null : "" + bytes.length));
        }
        if (this.debug) {
            System.out.println("");
        }
        return bytes;
    }

    public IImageMetadata getMetadata(ByteSource byteSource, Map params) throws ImageReadException, IOException {
        TiffImageMetadata exif = this.getExifMetadata(byteSource, params);
        JpegImageMetadata.Photoshop photoshop = this.getPhotoshopMetadata(byteSource);
        if (null == exif && null == photoshop) {
            return null;
        }
        JpegImageMetadata result = new JpegImageMetadata(photoshop, exif);
        return result;
    }

    public static boolean isExifAPP1Segment(GenericSegment segment) {
        byte[] bytes = segment.bytes;
        if (bytes == null || bytes.length < 4) {
            return false;
        }
        for (int i = 0; i < 4 && i < bytes.length; ++i) {
            if (bytes[i] == ExifIdentifierCode[i]) continue;
            return false;
        }
        return true;
    }

    private Vector filterAPP1Segments(Vector v) {
        Vector<GenericSegment> result = new Vector<GenericSegment>();
        for (int i = 0; i < v.size(); ++i) {
            GenericSegment segment = (GenericSegment)v.get(i);
            if (!JpegImageParser.isExifAPP1Segment(segment)) continue;
            result.add(segment);
        }
        return result;
    }

    public TiffImageMetadata getExifMetadata(ByteSource byteSource, Map params) throws ImageReadException, IOException {
        byte[] bytes = this.getExifRawData(byteSource);
        if (null == bytes) {
            return null;
        }
        return (TiffImageMetadata)new TiffImageParser().getMetadata(bytes, params);
    }

    public byte[] getExifRawData(ByteSource byteSource) throws ImageReadException, IOException {
        Vector segments = this.readSegments(byteSource, new int[]{65505}, false);
        if (segments == null || segments.size() < 1) {
            return null;
        }
        Vector exifSegments = this.filterAPP1Segments(segments);
        if (this.debug) {
            System.out.println("exif_segments.size: " + exifSegments.size());
        }
        if (exifSegments.size() > 1) {
            throw new ImageReadException("Sanselan currently can't parse EXIF metadata split across multiple APP1 segments.  Please send this image to the Sanselan project.");
        }
        GenericSegment segment = (GenericSegment)exifSegments.get(0);
        byte[] bytes = segment.bytes;
        return this.getBytearrayTail("trimmed exif bytes", bytes, 6);
    }

    private JpegImageMetadata.Photoshop getPhotoshopMetadata(ByteSource byteSource) throws ImageReadException, IOException {
        Vector segments = this.readSegments(byteSource, new int[]{65517}, false);
        if (segments == null || segments.size() < 1) {
            return null;
        }
        JpegImageMetadata.Photoshop result = new JpegImageMetadata.Photoshop();
        for (int i = 0; i < segments.size(); ++i) {
            App13Segment segment = (App13Segment)segments.get(i);
            Vector elements = segment.elements;
            for (int j = 0; j < elements.size(); ++j) {
                IptcElement element = (IptcElement)elements.get(j);
                result.add(element.getIptcTypeName(), element.getValue());
            }
        }
        return result;
    }

    public Dimension getImageSize(ByteSource byteSource) throws ImageReadException, IOException {
        Vector segments = this.readSegments(byteSource, new int[]{65472, 65473, 65474, 65475, 65477, 65478, 65479, 65481, 65482, 65483, 65485, 65486, 65487}, true);
        if (segments == null || segments.size() < 1) {
            throw new ImageReadException("No JFIF Data Found.");
        }
        if (segments.size() > 1) {
            throw new ImageReadException("Redundant JFIF Data Found.");
        }
        SOFNSegment fSOFNSegment = (SOFNSegment)segments.get(0);
        return new Dimension(fSOFNSegment.width, fSOFNSegment.height);
    }

    public byte[] embedICCProfile(byte[] image, byte[] profile) {
        return null;
    }

    public boolean embedICCProfile(File src, File dst, byte[] profile) {
        return false;
    }

    public ImageInfo getImageInfo(ByteSource byteSource) throws ImageReadException, IOException {
        String FormatDetails;
        Vector SOF_segments = this.readSegments(byteSource, new int[]{65472, 65473, 65474, 65475, 65477, 65478, 65479, 65481, 65482, 65483, 65485, 65486, 65487}, false);
        if (SOF_segments == null) {
            throw new ImageReadException("No SOFN Data Found.");
        }
        Vector JFIF_segments = this.readSegments(byteSource, new int[]{65504}, true);
        SOFNSegment fSOFNSegment = (SOFNSegment)SOF_segments.get(0);
        if (fSOFNSegment == null) {
            throw new ImageReadException("No SOFN Data Found.");
        }
        int Width = fSOFNSegment.width;
        int Height = fSOFNSegment.height;
        JFIFSegment fTheJFIFSegment = null;
        if (JFIF_segments != null && JFIF_segments.size() > 0) {
            fTheJFIFSegment = (JFIFSegment)JFIF_segments.get(0);
        }
        double x_density = -1.0;
        double y_density = -1.0;
        double units_per_inch = -1.0;
        if (fTheJFIFSegment != null) {
            x_density = fTheJFIFSegment.xDensity;
            y_density = fTheJFIFSegment.yDensity;
            int density_units = fTheJFIFSegment.density_units;
            FormatDetails = "Jpeg/JFIF v." + fTheJFIFSegment.JFIF_major_version + "." + fTheJFIFSegment.JFIF_minor_version;
            switch (density_units) {
                case 0: {
                    break;
                }
                case 1: {
                    units_per_inch = 1.0;
                    break;
                }
                case 2: {
                    units_per_inch = 2.54;
                    break;
                }
            }
        } else {
            JpegImageMetadata metadata = (JpegImageMetadata)this.getMetadata(byteSource);
            TiffField field = metadata.findEXIFValue(TiffField.TIFF_TAG_XResolution);
            if (field == null) {
                throw new ImageReadException("No XResolution");
            }
            x_density = ((Number)field.getValue()).doubleValue();
            field = metadata.findEXIFValue(TiffField.TIFF_TAG_YResolution);
            if (field == null) {
                throw new ImageReadException("No YResolution");
            }
            y_density = ((Number)field.getValue()).doubleValue();
            field = metadata.findEXIFValue(TiffField.TIFF_TAG_ResolutionUnit);
            if (field == null) {
                throw new ImageReadException("No ResolutionUnits");
            }
            int density_units = ((Number)field.getValue()).intValue();
            switch (density_units) {
                case 1: {
                    break;
                }
                case 2: {
                    units_per_inch = 1.0;
                    break;
                }
                case 3: {
                    units_per_inch = 2.54;
                    break;
                }
            }
            FormatDetails = "Jpeg/DCM";
        }
        int PhysicalHeightDpi = -1;
        float PhysicalHeightInch = -1.0f;
        int PhysicalWidthDpi = -1;
        float PhysicalWidthInch = -1.0f;
        if (units_per_inch > 0.0) {
            PhysicalWidthDpi = (int)Math.round(x_density / units_per_inch);
            PhysicalWidthInch = (float)((double)Width / (x_density * units_per_inch));
            PhysicalHeightDpi = (int)Math.round(y_density * units_per_inch);
            PhysicalHeightInch = (float)((double)Height / (y_density * units_per_inch));
        }
        Vector Comments = new Vector();
        int Number_of_components = fSOFNSegment.Number_of_components;
        int Precision = fSOFNSegment.Precision;
        int BitsPerPixel = Number_of_components * Precision;
        ImageFormat Format2 = ImageFormat.IMAGE_FORMAT_JPEG;
        String FormatName = "JPEG (Joint Photographic Experts Group) Format";
        String MimeType = "image/jpeg";
        int NumberOfImages = -1;
        boolean isProgressive = fSOFNSegment.marker == 65474;
        boolean isTransparent = false;
        boolean usesPalette = false;
        int ColorType = Number_of_components == 1 ? 0 : (Number_of_components == 3 ? 2 : (Number_of_components == 4 ? 3 : -2));
        String compressionAlgorithm = "JPEG";
        ImageInfo result = new ImageInfo(FormatDetails, BitsPerPixel, Comments, Format2, FormatName, Height, MimeType, NumberOfImages, PhysicalHeightDpi, PhysicalHeightInch, PhysicalWidthDpi, PhysicalWidthInch, Width, isProgressive, isTransparent, usesPalette, ColorType, compressionAlgorithm);
        return result;
    }

    public boolean dumpImageFile(PrintWriter pw, ByteSource byteSource) throws ImageReadException, IOException {
        pw.println("tiff.dumpImageFile");
        ImageInfo imageInfo = this.getImageInfo(byteSource);
        if (imageInfo == null) {
            return false;
        }
        imageInfo.toString(pw, "");
        pw.println("");
        Vector segments = this.readSegments(byteSource, null, false);
        if (segments == null) {
            throw new ImageReadException("No Segments Found.");
        }
        for (int d = 0; d < segments.size(); ++d) {
            Segment segment = (Segment)segments.get(d);
            NumberFormat nf = NumberFormat.getIntegerInstance();
            pw.println(d + ": marker: " + Integer.toHexString(segment.marker) + ", " + segment.getDescription() + " (length: " + nf.format(segment.length) + ")");
            segment.dump(pw);
        }
        pw.println("");
        return true;
    }
}

