/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sanselan.formats.png.chunks;

import java.io.IOException;
import org.apache.sanselan.ImageReadException;
import org.apache.sanselan.formats.png.chunks.PNGTextChunk;

public class PNGChunktEXt
extends PNGTextChunk {
    public final String Keyword;
    public final String Text;

    public PNGChunktEXt(int Length, int ChunkType, int CRC, byte[] bytes) throws ImageReadException, IOException {
        super(Length, ChunkType, CRC, bytes);
        int index = this.findNull(bytes);
        if (index < 0) {
            throw new ImageReadException("PNGChunktEXt: No Profile Name");
        }
        byte[] name_bytes = new byte[index];
        System.arraycopy(bytes, 0, name_bytes, 0, index);
        this.Keyword = new String(name_bytes);
        int TextLength = bytes.length - (index + 1);
        byte[] Text_bytes = new byte[TextLength];
        System.arraycopy(bytes, index + 1, Text_bytes, 0, TextLength);
        this.Text = new String(Text_bytes);
        if (this.getDebug()) {
            System.out.println("Keyword: " + this.Keyword);
            System.out.println("Text: " + this.Text);
        }
    }

    public String getKeyword() {
        return this.Keyword;
    }

    public String getText() {
        return this.Text;
    }
}

