/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sanselan.formats.tiff;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.sanselan.formats.tiff.TiffField;
import org.apache.sanselan.util.Debug;

public class TagInfo {
    public final int tag;
    public final String name;
    public final boolean isDate;
    private static final DateFormat DATE_FORMAT_1 = new SimpleDateFormat("yyyy:MM:dd HH:mm:ss");
    private static final DateFormat DATE_FORMAT_2 = new SimpleDateFormat("yyyy:MM:dd:HH:mm:ss");

    public TagInfo(int tag, String name) {
        this(tag, name, false);
    }

    public TagInfo(int tag, String name, boolean is_date) {
        this.tag = tag;
        this.name = name.trim();
        this.isDate = is_date;
    }

    public Object getValue(TiffField entry) {
        Object o = entry.fieldType.getSimpleValue(entry);
        if (this.isDate) {
            String s = (String)o;
            try {
                Date date = DATE_FORMAT_1.parse(s);
                return date;
            }
            catch (Exception e) {
                try {
                    Date date = DATE_FORMAT_2.parse(s);
                    return date;
                }
                catch (Exception e2) {
                    Debug.debug(e2);
                }
            }
        }
        return o;
    }

    public String toString() {
        return "[TagInfo. tag: " + this.tag + ", name: " + this.name + (this.isDate ? " (data)" : "") + "]";
    }
}

