/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sanselan.sampleUsage;

import java.io.File;
import java.io.IOException;
import java.util.Vector;
import org.apache.sanselan.ImageReadException;
import org.apache.sanselan.Sanselan;
import org.apache.sanselan.common.IImageMetadata;
import org.apache.sanselan.common.RationalNumber;
import org.apache.sanselan.formats.jpeg.JpegImageMetadata;
import org.apache.sanselan.formats.tiff.TagInfo;
import org.apache.sanselan.formats.tiff.TiffConstants;
import org.apache.sanselan.formats.tiff.TiffField;

public class MetadataExample {
    public static void metadataExample(File file) throws ImageReadException, IOException {
        IImageMetadata metadata = Sanselan.getMetadata(file);
        if (metadata instanceof JpegImageMetadata) {
            JpegImageMetadata jpegMetadata = (JpegImageMetadata)metadata;
            System.out.println("file: " + file.getPath());
            MetadataExample.printTagValue(jpegMetadata, TiffConstants.TIFF_TAG_XResolution);
            MetadataExample.printTagValue(jpegMetadata, TiffConstants.TIFF_TAG_DateTime);
            MetadataExample.printTagValue(jpegMetadata, TiffConstants.TIFF_TAG_DateTimeOriginal);
            MetadataExample.printTagValue(jpegMetadata, TiffConstants.TIFF_TAG_DateTimeDigitized);
            MetadataExample.printTagValue(jpegMetadata, TiffConstants.TIFF_TAG_ISOSpeedRatings);
            MetadataExample.printTagValue(jpegMetadata, TiffConstants.TIFF_TAG_ShutterSpeedValue);
            MetadataExample.printTagValue(jpegMetadata, TiffConstants.TIFF_TAG_ApertureValue);
            MetadataExample.printTagValue(jpegMetadata, TiffConstants.TIFF_TAG_BrightnessValue);
            MetadataExample.printTagValue(jpegMetadata, TiffConstants.TIFF_TAG_GPSLatitudeRef);
            MetadataExample.printTagValue(jpegMetadata, TiffConstants.TIFF_TAG_GPSLatitude);
            MetadataExample.printTagValue(jpegMetadata, TiffConstants.TIFF_TAG_GPSLongitudeRef);
            MetadataExample.printTagValue(jpegMetadata, TiffConstants.TIFF_TAG_GPSLongitude);
            System.out.println();
            TiffField gpsLatitudeRefField = jpegMetadata.findEXIFValue(TiffConstants.TIFF_TAG_GPSLatitudeRef);
            TiffField gpsLatitudeField = jpegMetadata.findEXIFValue(TiffConstants.TIFF_TAG_GPSLatitude);
            TiffField gpsLongitudeRefField = jpegMetadata.findEXIFValue(TiffConstants.TIFF_TAG_GPSLongitudeRef);
            TiffField gpsLongitudeField = jpegMetadata.findEXIFValue(TiffConstants.TIFF_TAG_GPSLongitude);
            if (gpsLatitudeRefField != null && gpsLatitudeField != null && gpsLongitudeRefField != null && gpsLongitudeField != null) {
                String gpsLatitudeRef = (String)gpsLatitudeRefField.getValue();
                RationalNumber[] gpsLatitude = (RationalNumber[])gpsLatitudeField.getValue();
                String gpsLongitudeRef = (String)gpsLongitudeRefField.getValue();
                RationalNumber[] gpsLongitude = (RationalNumber[])gpsLongitudeField.getValue();
                RationalNumber gpsLatitudeDegrees = gpsLatitude[0];
                RationalNumber gpsLatitudeMinutes = gpsLatitude[1];
                RationalNumber gpsLatitudeSeconds = gpsLatitude[2];
                RationalNumber gpsLongitudeDegrees = gpsLongitude[0];
                RationalNumber gpsLongitudeMinutes = gpsLongitude[1];
                RationalNumber gpsLongitudeSeconds = gpsLongitude[2];
                System.out.println("\tGPS Latitude: " + gpsLatitudeDegrees.toDisplayString() + " degrees, " + gpsLatitudeMinutes.toDisplayString() + " minutes, " + gpsLatitudeSeconds.toDisplayString() + " seconds " + gpsLatitudeRef);
                System.out.println("\tGPS Longitude: " + gpsLongitudeDegrees.toDisplayString() + " degrees, " + gpsLongitudeMinutes.toDisplayString() + " minutes, " + gpsLongitudeSeconds.toDisplayString() + " seconds " + gpsLongitudeRef);
            }
            System.out.println();
            Vector items = jpegMetadata.getItems();
            for (int i = 0; i < items.size(); ++i) {
                Object item = items.get(i);
                System.out.println("\titem: " + item);
            }
            System.out.println();
        }
    }

    private static void printTagValue(JpegImageMetadata jpegMetadata, TagInfo tagInfo) throws ImageReadException, IOException {
        TiffField field = jpegMetadata.findEXIFValue(tagInfo);
        if (field == null) {
            System.out.println(tagInfo.name + ": " + "Not Found.");
        } else {
            System.out.println(tagInfo.name + ": " + field.getValueDescription());
        }
    }
}

