/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sanselan.formats.tiff.debug;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.sanselan.formats.tiff.TiffField;
import org.apache.sanselan.formats.tiff.fieldtypes.FieldType;
import org.apache.sanselan.formats.tiff.fieldtypes.FieldTypeASCII;
import org.apache.sanselan.formats.tiff.fieldtypes.FieldTypeByte;
import org.apache.sanselan.formats.tiff.fieldtypes.FieldTypeDouble;
import org.apache.sanselan.formats.tiff.fieldtypes.FieldTypeFloat;
import org.apache.sanselan.formats.tiff.fieldtypes.FieldTypeLong;
import org.apache.sanselan.formats.tiff.fieldtypes.FieldTypeRational;
import org.apache.sanselan.formats.tiff.fieldtypes.FieldTypeShort;
import org.apache.sanselan.formats.tiff.fieldtypes.FieldTypeUnknown;
import org.apache.sanselan.util.Debug;

public class TiffConst {
    public static final int TIFF_COMPRESSION_UNCOMPRESSED_1 = 1;
    public static final int TIFF_COMPRESSION_UNCOMPRESSED = 1;
    public static final int TIFF_COMPRESSION_CCITT_1D = 2;
    public static final int TIFF_COMPRESSION_CCITT_GROUP_3 = 3;
    public static final int TIFF_COMPRESSION_CCITT_GROUP_4 = 4;
    public static final int TIFF_COMPRESSION_LZW = 5;
    public static final int TIFF_COMPRESSION_JPEG = 6;
    public static final int TIFF_COMPRESSION_UNCOMPRESSED_2 = 32771;
    public static final int TIFF_COMPRESSION_PACKBITS = 32773;
    public static final int PHOTOMETRIC_INTERPRETATION_WHITE_IS_ZERO = 0;
    public static final int PHOTOMETRIC_INTERPRETATION_BLACK_IS_ZERO = 1;
    public static final int PHOTOMETRIC_INTERPRETATION_RGB = 2;
    public static final int PHOTOMETRIC_INTERPRETATION_RGB_PALETTE = 3;
    public static final int PHOTOMETRIC_INTERPRETATION_TRANSPARENCY_MASK = 4;
    public static final int PHOTOMETRIC_INTERPRETATION_CMYK = 5;
    public static final int PHOTOMETRIC_INTERPRETATION_YCBCR = 6;
    public static final int PHOTOMETRIC_INTERPRETATION_CIELAB = 8;
    public static final FieldTypeByte FIELD_TYPE_BYTE = new FieldTypeByte(1, "Byte");
    public static final FieldTypeASCII FIELD_TYPE_ASCII = new FieldTypeASCII(2, "ASCII");
    public static final FieldTypeShort FIELD_TYPE_SHORT = new FieldTypeShort(3, "Short");
    public static final FieldTypeLong FIELD_TYPE_LONG = new FieldTypeLong(4, "Long");
    public static final FieldTypeRational FIELD_TYPE_RATIONAL = new FieldTypeRational(5, "Rational");
    public static final FieldType FIELD_TYPE_SBYTE = new FieldTypeByte(6, "SByte");
    public static final FieldType FIELD_TYPE_UNDEFINED = new FieldTypeByte(7, "Undefined");
    public static final FieldType FIELD_TYPE_SSHORT = new FieldTypeShort(8, "SShort");
    public static final FieldType FIELD_TYPE_SLONG = new FieldTypeLong(9, "SLong");
    public static final FieldType FIELD_TYPE_SRATIONAL = new FieldTypeRational(10, "SRational");
    public static final FieldType FIELD_TYPE_FLOAT = new FieldTypeFloat();
    public static final FieldType FIELD_TYPE_DOUBLE = new FieldTypeDouble();
    public static final FieldType FIELD_TYPE_UNKNOWN = new FieldTypeUnknown();
    public static final FieldType[] FIELD_TYPES = new FieldType[]{FIELD_TYPE_BYTE, FIELD_TYPE_ASCII, FIELD_TYPE_SHORT, FIELD_TYPE_LONG, FIELD_TYPE_RATIONAL, FIELD_TYPE_SBYTE, FIELD_TYPE_UNDEFINED, FIELD_TYPE_SSHORT, FIELD_TYPE_SLONG, FIELD_TYPE_SRATIONAL, FIELD_TYPE_FLOAT, FIELD_TYPE_DOUBLE};
    public static final FieldType[] FIELD_TYPE_ANY = FIELD_TYPES;

    public static class TagInfo2Date
    extends TagInfo2 {
        private static final DateFormat DATE_FORMAT_1 = new SimpleDateFormat("yyyy:MM:dd HH:mm:ss");
        private static final DateFormat DATE_FORMAT_2 = new SimpleDateFormat("yyyy:MM:dd:HH:mm:ss");

        public TagInfo2Date(String name, int tag, FieldType dataType, int length) {
            super(name, tag, dataType, length);
        }

        public Object getValue(TiffField entry) {
            Object o = entry.fieldType.getSimpleValue(entry);
            String s = (String)o;
            try {
                Date date = DATE_FORMAT_1.parse(s);
                return date;
            }
            catch (Exception e) {
                try {
                    Date date = DATE_FORMAT_2.parse(s);
                    return date;
                }
                catch (Exception e2) {
                    Debug.debug(e2);
                    return o;
                }
            }
        }

        public String toString() {
            return "[TagInfo. tag: " + this.tag + ", name: " + this.name + " (data)" + "]";
        }
    }

    public static class TagInfo2 {
        protected static final int LENGTH_UNKNOWN = -1;
        public final String name;
        public final int tag;
        public final FieldType[] dataTypes;
        public final int length;
        public final String lengthDescription;

        public TagInfo2(String name, int tag, FieldType dataType, int length, ExifDirectory exifDirectory) {
            this(name, tag, dataType, length);
        }

        public TagInfo2(String name, int tag, FieldType dataType, int length) {
            this(name, tag, new FieldType[]{dataType}, length, null);
        }

        public TagInfo2(String name, int tag, FieldType dataType, String lengthDescription) {
            this(name, tag, new FieldType[]{dataType}, -1, lengthDescription);
        }

        public TagInfo2(String name, int tag, FieldType[] dataTypes, int length) {
            this(name, tag, dataTypes, length, null);
        }

        public TagInfo2(String name, int tag, FieldType[] dataTypes, String lengthDescription) {
            this(name, tag, dataTypes, -1, lengthDescription);
        }

        public TagInfo2(String name, int tag, FieldType dataType) {
            this(name, tag, dataType, -1);
        }

        public TagInfo2(String name, int tag, FieldType[] dataTypes, int length, String lengthDescription) {
            this.name = name;
            this.tag = tag;
            this.dataTypes = dataTypes;
            this.length = length;
            this.lengthDescription = lengthDescription;
        }

        public Object getValue(TiffField entry) {
            Object o = entry.fieldType.getSimpleValue(entry);
            return o;
        }

        public String toString() {
            return "[TagInfo. tag: " + this.tag + ", name: " + this.name + "]";
        }
    }

    public static class ExifDirectory {
        public final String name;

        public ExifDirectory(String name) {
            this.name = name;
        }
    }
}

