/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads;

import android.app.Activity;
import android.content.Context;
import android.content.res.Resources;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.google.ads.Ad;
import com.google.ads.AdListener;
import com.google.ads.AdRequest;
import com.google.ads.AdSize;
import com.google.ads.AppEventListener;
import com.google.ads.internal.AdWebView;
import com.google.ads.internal.b;
import com.google.ads.internal.d;
import com.google.ads.internal.j;
import com.google.ads.util.AdUtil;
import java.util.HashSet;
import java.util.Set;

public class AdView
extends RelativeLayout
implements Ad {
    private d a;

    public AdView(Activity activity, AdSize adSize, String adUnitId) {
        super(activity.getApplicationContext());
        try {
            this.a((Context)activity, adSize, null);
            this.b((Context)activity, adSize, null);
            this.a(activity, adSize, adUnitId);
        }
        catch (b b2) {
            this.a((Context)activity, b2.c("Could not initialize AdView"), adSize, null);
            b2.a("Could not initialize AdView");
        }
    }

    protected AdView(Activity activity, AdSize[] adSizes, String adUnitId) {
        this(activity, new AdSize(0, 0), adUnitId);
        this.a(adSizes);
    }

    public AdView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.a(context, attrs);
    }

    public AdView(Context context, AttributeSet attrs, int defStyle) {
        this(context, attrs);
    }

    void a(Context context, String string, int n2, AdSize adSize, AttributeSet attributeSet) {
        if (adSize == null) {
            adSize = AdSize.BANNER;
        }
        adSize = AdSize.createAdSize(adSize, context.getApplicationContext());
        if (this.getChildCount() == 0) {
            TextView textView = attributeSet == null ? new TextView(context) : new TextView(context, attributeSet);
            textView.setGravity(17);
            textView.setText((CharSequence)string);
            textView.setTextColor(n2);
            textView.setBackgroundColor(-16777216);
            LinearLayout linearLayout = attributeSet == null ? new LinearLayout(context) : new LinearLayout(context, attributeSet);
            linearLayout.setGravity(17);
            LinearLayout linearLayout2 = attributeSet == null ? new LinearLayout(context) : new LinearLayout(context, attributeSet);
            linearLayout2.setGravity(17);
            linearLayout2.setBackgroundColor(n2);
            int n3 = this.a(context, adSize.getWidth());
            int n4 = this.a(context, adSize.getHeight());
            linearLayout.addView((View)textView, n3 - 2, n4 - 2);
            linearLayout2.addView((View)linearLayout);
            this.addView((View)linearLayout2, n3, n4);
        }
    }

    private int a(Context context, int n2) {
        return (int)TypedValue.applyDimension((int)1, (float)n2, (DisplayMetrics)context.getResources().getDisplayMetrics());
    }

    private boolean a(Context context, AdSize adSize, AttributeSet attributeSet) {
        if (!AdUtil.c(context)) {
            this.a(context, "You must have AdActivity declared in AndroidManifest.xml with configChanges.", adSize, attributeSet);
            return false;
        }
        return true;
    }

    private boolean b(Context context, AdSize adSize, AttributeSet attributeSet) {
        if (!AdUtil.b(context)) {
            this.a(context, "You must have INTERNET and ACCESS_NETWORK_STATE permissions in AndroidManifest.xml.", adSize, attributeSet);
            return false;
        }
        return true;
    }

    public void destroy() {
        this.a.b();
    }

    private void a(Context context, String string, AdSize adSize, AttributeSet attributeSet) {
        com.google.ads.util.b.b(string);
        this.a(context, string, -65536, adSize, attributeSet);
    }

    AdSize[] a(String string) {
        String[] stringArray = string.split(",");
        AdSize[] adSizeArray = new AdSize[stringArray.length];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            String string2 = stringArray[i2].trim();
            AdSize adSize = null;
            if (string2.matches("^(\\d+|FULL_WIDTH)\\s*[xX]\\s*(\\d+|AUTO_HEIGHT)$")) {
                String[] stringArray2 = string2.split("[xX]");
                stringArray2[0] = stringArray2[0].trim();
                stringArray2[1] = stringArray2[1].trim();
                int n2 = 0;
                int n3 = 0;
                try {
                    n2 = "FULL_WIDTH".equals(stringArray2[0]) ? -1 : Integer.parseInt(stringArray2[0]);
                    n3 = "AUTO_HEIGHT".equals(stringArray2[1]) ? -2 : Integer.parseInt(stringArray2[1]);
                }
                catch (NumberFormatException numberFormatException) {
                    return null;
                }
                adSize = new AdSize(n2, n3);
            } else {
                AdSize adSize2 = "BANNER".equals(string2) ? AdSize.BANNER : ("SMART_BANNER".equals(string2) ? AdSize.SMART_BANNER : ("IAB_MRECT".equals(string2) ? AdSize.IAB_MRECT : ("IAB_BANNER".equals(string2) ? AdSize.IAB_BANNER : ("IAB_LEADERBOARD".equals(string2) ? AdSize.IAB_LEADERBOARD : (adSize = "IAB_WIDE_SKYSCRAPER".equals(string2) ? AdSize.IAB_WIDE_SKYSCRAPER : null)))));
            }
            if (adSize == null) {
                return null;
            }
            adSizeArray[i2] = adSize;
        }
        return adSizeArray;
    }

    private void a(Context context, AttributeSet attributeSet) {
        block11: {
            if (attributeSet == null) {
                return;
            }
            AdSize[] adSizeArray = null;
            try {
                String string = this.b("adSize", context, attributeSet, true);
                adSizeArray = this.a(string);
                if (adSizeArray == null || adSizeArray.length == 0) {
                    throw new b("Attribute \"adSize\" invalid: " + string, true);
                }
                if (!this.a("adUnitId", attributeSet)) {
                    throw new b("Required XML attribute \"adUnitId\" missing", true);
                }
                if (this.isInEditMode()) {
                    this.a(context, "Ads by Google", -1, adSizeArray[0], attributeSet);
                    break block11;
                }
                String string2 = this.b("adUnitId", context, attributeSet, true);
                boolean bl = this.a("loadAdOnCreate", context, attributeSet, false);
                if (context instanceof Activity) {
                    Activity activity = (Activity)context;
                    this.a((Context)activity, adSizeArray[0], attributeSet);
                    this.b((Context)activity, adSizeArray[0], attributeSet);
                    if (adSizeArray.length == 1) {
                        this.a(activity, adSizeArray[0], string2);
                    } else {
                        this.a(activity, new AdSize(0, 0), string2);
                        this.a(adSizeArray);
                    }
                    if (bl) {
                        Set<String> set = this.c("testDevices", context, attributeSet, false);
                        if (set.contains("TEST_EMULATOR")) {
                            set.remove("TEST_EMULATOR");
                            set.add(AdRequest.TEST_EMULATOR);
                        }
                        this.loadAd(new AdRequest().setTestDevices(set).setKeywords(this.c("keywords", context, attributeSet, false)));
                    }
                    break block11;
                }
                throw new b("AdView was initialized with a Context that wasn't an Activity.", true);
            }
            catch (b b2) {
                this.a(context, b2.c("Could not initialize AdView"), adSizeArray != null && adSizeArray.length > 0 ? adSizeArray[0] : AdSize.BANNER, attributeSet);
                b2.a("Could not initialize AdView");
                if (this.isInEditMode()) break block11;
                b2.b("Could not initialize AdView");
            }
        }
    }

    private boolean a(String string, Context context, AttributeSet attributeSet, boolean bl) throws b {
        String string2 = attributeSet.getAttributeValue("http://schemas.android.com/apk/lib/com.google.ads", string);
        boolean bl2 = attributeSet.getAttributeBooleanValue("http://schemas.android.com/apk/lib/com.google.ads", string, bl);
        if (string2 != null) {
            String string3 = context.getPackageName();
            if (string2.matches("^@([^:]+)\\:(.*)$")) {
                string3 = string2.replaceFirst("^@([^:]+)\\:(.*)$", "$1");
                string2 = string2.replaceFirst("^@([^:]+)\\:(.*)$", "@$2");
            }
            if (string2.startsWith("@bool/")) {
                String string4 = string2.substring("@bool/".length());
                TypedValue typedValue = new TypedValue();
                try {
                    this.getResources().getValue(string3 + ":bool/" + string4, typedValue, true);
                }
                catch (Resources.NotFoundException notFoundException) {
                    throw new b("Could not find resource for " + string + ": " + string2, true, notFoundException);
                }
                if (typedValue.type == 18) {
                    bl2 = typedValue.data != 0;
                } else {
                    throw new b("Resource " + string + " was not a boolean: " + typedValue, true);
                }
            }
        }
        return bl2;
    }

    private String b(String string, Context context, AttributeSet attributeSet, boolean bl) throws b {
        String string2 = attributeSet.getAttributeValue("http://schemas.android.com/apk/lib/com.google.ads", string);
        if (string2 != null) {
            String string3 = context.getPackageName();
            if (string2.matches("^@([^:]+)\\:(.*)$")) {
                string3 = string2.replaceFirst("^@([^:]+)\\:(.*)$", "$1");
                string2 = string2.replaceFirst("^@([^:]+)\\:(.*)$", "@$2");
            }
            if (string2.startsWith("@string/")) {
                String string4 = string2.substring("@string/".length());
                TypedValue typedValue = new TypedValue();
                try {
                    this.getResources().getValue(string3 + ":string/" + string4, typedValue, true);
                }
                catch (Resources.NotFoundException notFoundException) {
                    throw new b("Could not find resource for " + string + ": " + string2, true, notFoundException);
                }
                if (typedValue.string != null) {
                    string2 = ((Object)typedValue.string).toString();
                } else {
                    throw new b("Resource " + string + " was not a string: " + typedValue, true);
                }
            }
        }
        if (bl && string2 == null) {
            throw new b("Required XML attribute \"" + string + "\" missing", true);
        }
        return string2;
    }

    private Set<String> c(String string, Context context, AttributeSet attributeSet, boolean bl) throws b {
        String string2 = this.b(string, context, attributeSet, bl);
        HashSet<String> hashSet = new HashSet<String>();
        if (string2 != null) {
            String[] stringArray;
            for (String string3 : stringArray = string2.split(",")) {
                if ((string3 = string3.trim()).length() == 0) continue;
                hashSet.add(string3);
            }
        }
        return hashSet;
    }

    private boolean a(String string, AttributeSet attributeSet) {
        return attributeSet.getAttributeValue("http://schemas.android.com/apk/lib/com.google.ads", string) != null;
    }

    private void a(Activity activity, AdSize adSize, String string) throws b {
        FrameLayout frameLayout = new FrameLayout((Context)activity);
        frameLayout.setFocusable(false);
        this.a = new d(this, activity, adSize, string, (ViewGroup)frameLayout, false);
        this.setGravity(17);
        try {
            ViewGroup viewGroup = j.a(activity, this.a);
            if (viewGroup != null) {
                viewGroup.addView((View)frameLayout, -2, -2);
                this.addView((View)viewGroup, -2, -2);
            } else {
                this.addView((View)frameLayout, -2, -2);
            }
        }
        catch (VerifyError verifyError) {
            com.google.ads.util.b.a("Gestures disabled: Not supported on this version of Android.", verifyError);
            this.addView((View)frameLayout, -2, -2);
        }
    }

    @Override
    public boolean isReady() {
        if (this.a == null) {
            return false;
        }
        return this.a.r();
    }

    public boolean isRefreshing() {
        if (this.a == null) {
            return false;
        }
        return this.a.s();
    }

    @Override
    public void loadAd(AdRequest adRequest) {
        if (this.a != null) {
            if (this.isRefreshing()) {
                this.a.e();
            }
            this.a.a(adRequest);
        }
    }

    @Override
    public void setAdListener(AdListener adListener) {
        this.a.h().m.a(adListener);
    }

    protected void setAppEventListener(AppEventListener appEventListener) {
        this.a.h().n.a(appEventListener);
    }

    protected void setSupportedAdSizes(AdSize ... adSizes) {
        if (this.a.h().l.a() == null) {
            com.google.ads.util.b.b("Error: Tried to set supported ad sizes on a single-size AdView.");
            return;
        }
        this.a(adSizes);
    }

    private void a(AdSize ... adSizeArray) {
        AdSize[] adSizeArray2 = new AdSize[adSizeArray.length];
        for (int i2 = 0; i2 < adSizeArray.length; ++i2) {
            adSizeArray2[i2] = AdSize.createAdSize(adSizeArray[i2], this.getContext());
        }
        this.a.h().l.a(adSizeArray2);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        AdWebView adWebView = this.a.k();
        if (adWebView != null) {
            adWebView.setVisibility(0);
        }
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    @Override
    public void stopLoading() {
        if (this.a != null) {
            this.a.A();
        }
    }
}

