/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.mediation;

import com.google.ads.util.b;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;

public abstract class MediationServerParameters {
    public void load(Map<String, String> parameters) throws MappingException {
        HashMap<String, Field> hashMap = new HashMap<String, Field>();
        for (Field field : this.getClass().getFields()) {
            Parameter parameter = field.getAnnotation(Parameter.class);
            if (parameter == null) continue;
            hashMap.put(parameter.name(), field);
        }
        if (hashMap.isEmpty()) {
            b.e("No server options fields detected.  To suppress this message either add a field with the @Parameter annotation, or override the load() method");
        }
        for (Map.Entry entry : parameters.entrySet()) {
            Field field = (Field)hashMap.remove(entry.getKey());
            if (field != null) {
                try {
                    field.set(this, entry.getValue());
                }
                catch (IllegalAccessException illegalAccessException) {
                    b.b("Server Option '" + (String)entry.getKey() + "' could not be set: Illegal Access");
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    b.b("Server Option '" + (String)entry.getKey() + "' could not be set: Bad Type");
                }
                continue;
            }
            b.e("Unexpected Server Option: " + (String)entry.getKey() + " = '" + (String)entry.getValue() + "'");
        }
        Object object = null;
        for (Field field : hashMap.values()) {
            if (!field.getAnnotation(Parameter.class).required()) continue;
            b.b("Required Server Option missing: " + field.getAnnotation(Parameter.class).name());
            object = (object == null ? "" : (String)object + ", ") + field.getAnnotation(Parameter.class).name();
        }
        if (object != null) {
            throw new MappingException("Required Server Option(s) missing: " + (String)object);
        }
        this.a();
    }

    protected void a() {
    }

    public static class MappingException
    extends Exception {
        public MappingException(String message) {
            super(message);
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    protected static @interface Parameter {
        public String name();

        public boolean required() default true;
    }
}

