/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sanselan.formats.tiff;

import java.io.IOException;
import java.util.Vector;
import org.apache.sanselan.ImageReadException;
import org.apache.sanselan.common.byteSources.ByteSource;
import org.apache.sanselan.formats.tiff.TagInfo;
import org.apache.sanselan.formats.tiff.TiffConstants;
import org.apache.sanselan.formats.tiff.TiffElement;
import org.apache.sanselan.formats.tiff.TiffField;

public class TiffDirectory
extends TiffElement
implements TiffConstants {
    public static final int DIRECTORY_TYPE_UNKNOWN = -1;
    public static final int DIRECTORY_TYPE_ROOT = 1;
    public static final int DIRECTORY_TYPE_SUB = 2;
    public static final int DIRECTORY_TYPE_THUMBNAIL = 3;
    public static final int DIRECTORY_TYPE_EXIF = 4;
    public static final int DIRECTORY_TYPE_GPS = 6;
    public static final int DIRECTORY_TYPE_INTEROPERABILITY = 7;
    public final int type;
    public final Vector entries;
    public final int nextDirectoryOffset;

    public String description() {
        return TiffDirectory.description(this.type);
    }

    public String getElementDescription(boolean verbose) {
        if (!verbose) {
            return "TIFF Directory (" + this.description() + ")";
        }
        int entryOffset = this.offset + 4;
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < this.entries.size(); ++i) {
            TiffField entry = (TiffField)this.entries.get(i);
            result.append("\t");
            result.append("[" + entryOffset + "]: ");
            result.append(entry.tagInfo.name);
            result.append(" (" + entry.tagInfo.tag + ", 0x" + Integer.toHexString(entry.tagInfo.tag) + ")");
            result.append(", " + entry.fieldType.name);
            result.append(", " + entry.fieldType.getRawBytes(entry).length);
            result.append(": " + entry.getValueDescription());
            result.append("\n");
            entryOffset += 12;
        }
        return result.toString();
    }

    public static final String description(int type) {
        switch (type) {
            case -1: {
                return "Unknown";
            }
            case 1: {
                return "Root";
            }
            case 2: {
                return "Sub";
            }
            case 3: {
                return "Thumbnail";
            }
            case 4: {
                return "Exif";
            }
            case 6: {
                return "Gps";
            }
            case 7: {
                return "Interoperability";
            }
        }
        return "Bad Type";
    }

    public TiffDirectory(int type, Vector entries, int offset, int nextDirectoryOffset) {
        super(offset, 4 + entries.size() * 12 + 2);
        this.type = type;
        this.entries = entries;
        this.nextDirectoryOffset = nextDirectoryOffset;
    }

    public Vector getDirectoryEntrys() {
        return new Vector(this.entries);
    }

    public void fillInValues(ByteSource byteSource) throws ImageReadException, IOException {
        for (int i = 0; i < this.entries.size(); ++i) {
            TiffField entry = (TiffField)this.entries.get(i);
            entry.fillInValue(byteSource);
        }
    }

    public void dump() {
        for (int i = 0; i < this.entries.size(); ++i) {
            TiffField entry = (TiffField)this.entries.get(i);
            entry.dump();
        }
    }

    public boolean hasJpegImageData() {
        return null != this.findField(TIFF_TAG_JPEGInterchangeFormat);
    }

    public boolean hasTiffImageData() {
        if (null != this.findField(TIFF_TAG_TileOffsets)) {
            return true;
        }
        return null != this.findField(TIFF_TAG_StripOffsets);
    }

    public TiffField findField(TagInfo tag) {
        if (this.entries == null) {
            return null;
        }
        for (int i = 0; i < this.entries.size(); ++i) {
            TiffField field = (TiffField)this.entries.get(i);
            if (field.tag != tag.tag) continue;
            return field;
        }
        return null;
    }

    private Vector getRawImageDataElements(TiffField offsetsField, TiffField byteCountsField) throws ImageReadException {
        int[] byteCounts;
        int[] offsets = offsetsField.getValueAsIntArray();
        if (offsets.length != (byteCounts = byteCountsField.getValueAsIntArray()).length) {
            throw new ImageReadException("offsets.length(" + offsets.length + ") != byteCounts.length(" + byteCounts.length + ")");
        }
        Vector<ImageDataElement> result = new Vector<ImageDataElement>();
        for (int i = 0; i < offsets.length; ++i) {
            result.add(new ImageDataElement(offsets[i], byteCounts[i]));
        }
        return result;
    }

    public Vector getTiffRawImageDataElements() throws ImageReadException {
        TiffField tileOffsets = this.findField(TIFF_TAG_TileOffsets);
        TiffField tileByteCounts = this.findField(TIFF_TAG_TileByteCounts);
        TiffField stripOffsets = this.findField(TIFF_TAG_StripOffsets);
        TiffField stripByteCounts = this.findField(TIFF_TAG_StripByteCounts);
        if (tileOffsets != null && tileByteCounts != null) {
            return this.getRawImageDataElements(tileOffsets, tileByteCounts);
        }
        if (stripOffsets != null && stripByteCounts != null) {
            return this.getRawImageDataElements(stripOffsets, stripByteCounts);
        }
        throw new ImageReadException("Couldn't find image data.");
    }

    public boolean imageDataInStrips() throws ImageReadException {
        TiffField tileOffsets = this.findField(TIFF_TAG_TileOffsets);
        TiffField tileByteCounts = this.findField(TIFF_TAG_TileByteCounts);
        TiffField stripOffsets = this.findField(TIFF_TAG_StripOffsets);
        TiffField stripByteCounts = this.findField(TIFF_TAG_StripByteCounts);
        if (tileOffsets != null && tileByteCounts != null) {
            return false;
        }
        if (stripOffsets != null && stripByteCounts != null) {
            return true;
        }
        if (stripOffsets != null && stripByteCounts != null) {
            return true;
        }
        throw new ImageReadException("Couldn't find image data.");
    }

    public ImageDataElement getJpegRawImageDataElement() throws ImageReadException {
        TiffField jpegInterchangeFormat = this.findField(TIFF_TAG_JPEGInterchangeFormat);
        TiffField jpegInterchangeFormatLength = this.findField(TIFF_TAG_JPEGInterchangeFormatLength);
        if (jpegInterchangeFormat != null && jpegInterchangeFormatLength != null) {
            int offset = jpegInterchangeFormat.getValueAsIntArray()[0];
            int byteCount = jpegInterchangeFormatLength.getValueAsIntArray()[0];
            return new ImageDataElement(offset, byteCount);
        }
        throw new ImageReadException("Couldn't find image data.");
    }

    public final class ImageDataElement
    extends TiffElement {
        public ImageDataElement(int offset, int length) {
            super(offset, length);
        }

        public String getElementDescription(boolean verbose) {
            if (verbose) {
                return null;
            }
            return "ImageDataElement";
        }
    }
}

