/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sanselan.common.byteSources;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.sanselan.common.byteSources.ByteSource;

public class ByteSourceArray
extends ByteSource {
    private final byte[] bytes;

    public ByteSourceArray(String filename, byte[] bytes) {
        super(filename);
        this.bytes = bytes;
    }

    public ByteSourceArray(byte[] bytes) {
        super(null);
        this.bytes = bytes;
    }

    public InputStream getInputStream() {
        return new ByteArrayInputStream(this.bytes);
    }

    public byte[] getBlock(int start, int length) throws IOException {
        if (start + length > this.bytes.length) {
            throw new IOException("Could not read block.");
        }
        byte[] result = new byte[length];
        System.arraycopy(this.bytes, start, result, 0, length);
        return result;
    }

    public byte[] getAll() throws IOException {
        return this.bytes;
    }

    public String getDescription() {
        return this.bytes.length + " byte array";
    }
}

