package com.sound;

import java.io.IOException;

import android.content.res.AssetFileDescriptor;
import android.content.res.AssetManager;
import android.media.MediaPlayer;
 
public class game_mediaplayerEx extends MediaPlayer
{
        public boolean playRequested = false;
        public boolean isPrepared = false;
        @Override
        public void prepare() throws IOException, IllegalStateException
        {
                super.prepare();
                this.isPrepared = true;
        }
        @Override
        public void prepareAsync() throws IllegalStateException
        {
                this.isPrepared = false;
                this.setOnPreparedListener(new MediaPlayer.OnPreparedListener()
                {
                      public void onPrepared(MediaPlayer mp)
                      {
                          isPrepared = true;
                          if ( playRequested )
                          {
                                  start();
                          }
                      }
            });        
                super.prepareAsync();
        }
        @Override
        public void start() throws IllegalStateException
        {
                if ( this.isPrepared )
                {
                        this.playRequested = false;
                        super.start();
                }
                else
                {
                        this.playRequested = true;
                }
        }
        @Override
        public void stop() throws IllegalStateException
        {
                if ( this.playRequested )
                {
                        this.playRequested = false;
                }
                super.stop();
        }
       
        public void setDataSourceFromAsset(AssetManager assetMgr, String path) throws IOException
        {
                AssetFileDescriptor fd = assetMgr.openFd(path);
                this.setDataSource(fd.getFileDescriptor(), fd.getStartOffset(), fd.getLength());
        }
       
 
}